/*
 * Decompiled with CFR 0.152.
 */
package de.mindpipe.android.logging.log4j;

import android.util.Log;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class LogCatAppender
extends AppenderSkeleton {
    protected Layout tagLayout;

    public LogCatAppender(Layout messageLayout, Layout tagLayout) {
        this.tagLayout = tagLayout;
        this.setLayout(messageLayout);
    }

    public LogCatAppender(Layout messageLayout) {
        this(messageLayout, new PatternLayout("%c"));
    }

    public LogCatAppender() {
        this(new PatternLayout("%m%n"));
    }

    @Override
    protected void append(LoggingEvent le) {
        switch (le.getLevel().toInt()) {
            case 5000: {
                if (le.getThrowableInformation() != null) {
                    Log.v((String)this.getTagLayout().format(le), (String)this.getLayout().format(le), (Throwable)le.getThrowableInformation().getThrowable());
                    break;
                }
                Log.v((String)this.getTagLayout().format(le), (String)this.getLayout().format(le));
                break;
            }
            case 10000: {
                if (le.getThrowableInformation() != null) {
                    Log.d((String)this.getTagLayout().format(le), (String)this.getLayout().format(le), (Throwable)le.getThrowableInformation().getThrowable());
                    break;
                }
                Log.d((String)this.getTagLayout().format(le), (String)this.getLayout().format(le));
                break;
            }
            case 20000: {
                if (le.getThrowableInformation() != null) {
                    Log.i((String)this.getTagLayout().format(le), (String)this.getLayout().format(le), (Throwable)le.getThrowableInformation().getThrowable());
                    break;
                }
                Log.i((String)this.getTagLayout().format(le), (String)this.getLayout().format(le));
                break;
            }
            case 30000: {
                if (le.getThrowableInformation() != null) {
                    Log.w((String)this.getTagLayout().format(le), (String)this.getLayout().format(le), (Throwable)le.getThrowableInformation().getThrowable());
                    break;
                }
                Log.w((String)this.getTagLayout().format(le), (String)this.getLayout().format(le));
                break;
            }
            case 40000: {
                if (le.getThrowableInformation() != null) {
                    Log.e((String)this.getTagLayout().format(le), (String)this.getLayout().format(le), (Throwable)le.getThrowableInformation().getThrowable());
                    break;
                }
                Log.e((String)this.getTagLayout().format(le), (String)this.getLayout().format(le));
                break;
            }
            case 50000: {
                if (le.getThrowableInformation() != null) {
                    Log.wtf((String)this.getTagLayout().format(le), (String)this.getLayout().format(le), (Throwable)le.getThrowableInformation().getThrowable());
                    break;
                }
                Log.wtf((String)this.getTagLayout().format(le), (String)this.getLayout().format(le));
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean requiresLayout() {
        return true;
    }

    public Layout getTagLayout() {
        return this.tagLayout;
    }

    public void setTagLayout(Layout tagLayout) {
        this.tagLayout = tagLayout;
    }
}

