/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.dashboard.view;

public class Result<R> {
    private int code;
    private String msg;
    private R data;

    public static <R> Result<R> ofSuccess(R data) {
        Result result = new Result();
        result.setMsg("success");
        result.setData(data);
        return result;
    }

    public static <R> Result<R> ofSuccessMsg(String msg) {
        Result result = new Result();
        result.setMsg(msg);
        return result;
    }

    public static <R> Result<R> ofFail(int code, String msg) {
        Result result = new Result();
        result.setCode(code);
        result.setMsg(msg);
        return result;
    }

    public static <R> Result<R> ofThrowable(int code, Throwable throwable) {
        Result result = new Result();
        result.setCode(code);
        result.setMsg(throwable.getClass().getName() + ", " + throwable.getMessage());
        return result;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public R getData() {
        return (R)this.data;
    }

    public void setData(R data) {
        this.data = data;
    }
}

