package com.xxfc.platform.vehicle.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

@Data
@Table(name = "vehicle")
public class  Vehicle {
    /**
     * 主键(uuid)
     */
    @Id
    private String id;

    /**
     * 车辆编号，0-没有
     */
    private Integer code;

    /**
     * 车辆状态： 1-正常运行 2-维修 3-报废
     */
    private Integer status;

    /**
     * 车牌号，空字符串-没有
     */
    @Column(name = "number_plate")
    private String numberPlate;

    /**
     * 品牌（编码，对应关系见相关常量），0-未填写
     */
    private Integer brand;

    /**
     * 所属分支机构（id）
     */
    @Column(name = "subordinate_branch")
    private Integer subordinateBranch;

    /**
     * 用途类型：租赁房车（1）、展车等，对应关系见车辆常量表
     */
    @Column(name = "use_type")
    private Integer useType;

    /**
     * 备注信息
     */
    private String remark;

    /**
     * 车架号
     */
    private String vin;

    /**
     * 保险公司，见常量表
     */
    private Integer insuranceCompany;


    /**
     * 保险单号
     */
    private String insuranceNo;

    /**
     * 保险开始时间
     */
    private Date insuranceStartDate;

    /**
     * 保险结束时间
     */
    private Date insuranceEndDate;

    /**
     * 年审时间
     */
    private Date annualVerificationDate;

    /**
     * 保养时间
     */
    private Date maintenanceDate;

    /**
     * 保养里程数
     */
    private Integer maintenanceMileage;

    /**
     * 车辆所属人-类型
     */
    private Integer belongTo;

    /**
     * 所属人 名称
     */
    private String belongToName;

    /**
     * 行驶证路径
     */
    private String drivingLicensePath;

    /**
     * 发动机号
     */
    private String engineNum;

    /**
     * 生产商
     */
    private String manufacturer;

    /**
     * 收车时间
     */
    private Date receiveTime;

    /**
     * 最后更新里程数
     */
    private Integer mileageLastUpdate;

    /**
     * 停车分公司（id）
     */
    @Column(name = "park_branch_company_id")
    private Integer parkBranchCompanyId;
    /**
     * 预计目的地分公司id
     */
    private Integer expectDestinationBranchCompanyId;
    /**
     * 车型id
     */
    @Column(name = "model_id")
    private Integer modelId;

    /**
     * 车辆当前出行状态： 1-出行中 2-预约中 3-空闲中 4-保养中
     */
    @Column(name = "travel_status")
    private Integer travelStatus;

    /**
     * 终端号
     */
    @Column(name = "terminal_number")
    private String terminalNumber;

    /**
     * SIM卡号
     */
    @Column(name = "sim_number")
    private String simNumber;

    /**
     * 通讯类型
     */
    @Column(name = "communication_type")
    private String communicationType;

    /**
     * 是否删除；0-正常；1-删除
     */
    private Integer isDel;
}