package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehiclePublishReceiveBiz;
import com.xxfc.platform.vehicle.pojo.dto.VehiclePublishFindDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehiclePublishReceiveDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/publishAeceive")
@Api(tags = {"商品需求"})
public class AppVehiclePublishReceiveController extends BaseController<VehiclePublishReceiveBiz> {





    @PostMapping("meet")
    @ApiModelProperty("接单")
    public  ObjectRestResponse meet(@RequestBody VehiclePublishReceiveDTO publishReceiveDTO) throws Exception {
        setPublishReceiveDTO(publishReceiveDTO);
        return ObjectRestResponse.succ(baseBiz.receive(publishReceiveDTO));
    }



    @PostMapping("confirmOrder")
    @ApiModelProperty("确认订单")
    public  ObjectRestResponse confirmOrder(@RequestBody VehiclePublishReceiveDTO publishReceiveDTO) throws Exception {
        setPublishReceiveDTO(publishReceiveDTO);
        return ObjectRestResponse.succ(baseBiz.confirmOrder(publishReceiveDTO));
    }



    public  void  setPublishReceiveDTO(VehiclePublishReceiveDTO publishReceiveDTO)throws Exception{
        if (publishReceiveDTO.getCompanyId() == null || publishReceiveDTO.getCompanyId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                publishReceiveDTO.setCompanyId(companyIds.get(0));
            }
        }
        publishReceiveDTO.setUserId(Integer.parseInt(getUserId()));
    }



    @PostMapping("app/unauth/updReceive")
    @ApiModelProperty("支付后处理")
    @IgnoreUserToken
    public  ObjectRestResponse updReceive(@RequestBody VehiclePublishReceiveDTO publishReceiveDTO) {
        baseBiz.updOrderReceive(publishReceiveDTO);
        return ObjectRestResponse.succ();
    }


    @GetMapping("selectList")
    @ApiModelProperty("我的接单")
    public  ObjectRestResponse selectListByCompany(VehiclePublishFindDTO publishFindDTO) {
        if (publishFindDTO.getCompanyId() == null || publishFindDTO.getCompanyId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                publishFindDTO.setCompanyId(companyIds.get(0));
            }
        }
        return  ObjectRestResponse.succ(baseBiz.selectList(publishFindDTO));
    }


    @GetMapping("detail")
    @ApiModelProperty("我的接单详情")
    public  ObjectRestResponse detail(VehiclePublishFindDTO publishFindDTO) {
        return  ObjectRestResponse.succ(baseBiz.getInfo(publishFindDTO.getOrderNo()));
    }












}
