package com.github.wxiaoqi.security.admin.rest;



import com.github.wxiaoqi.security.admin.biz.CompanyWalletDetailBiz;
import com.github.wxiaoqi.security.admin.dto.WalletDetailDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/companyWalletDetail")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Api(tags = {"店铺钱包明细"})
public class AppCompanyWalletDetailController extends BaseController<CompanyWalletDetailBiz> {




    @GetMapping("selectList")
    @ApiModelProperty("钱包明细")
    public  ObjectRestResponse info(WalletDetailDTO walletDetailDTO) {
        if (walletDetailDTO.getCompanyId() == null || walletDetailDTO.getCompanyId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                walletDetailDTO.setCompanyId(companyIds.get(0));
            }
        }
        return ObjectRestResponse.succ(baseBiz.selectListByCompanyId(walletDetailDTO));
    }




}
