package com.github.wxiaoqi.security.admin.constant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum CompanyWalletSourceEnum {

    VEHICLE(1, "商家订单"),
    WATER(2, "上级商家拥金"),
    VIOLATE(3, "违约金"),
    REGULATION(4, "违章补偿"),
    LOSS(5, "定损"),
    CATH(6, "提现"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    public static Map<Integer, CompanyWalletSourceEnum> codeAndDesc = new HashMap<Integer, CompanyWalletSourceEnum>();
            //Maps.newHashMap();

    static{
        for(CompanyWalletSourceEnum enumE : CompanyWalletSourceEnum.values()){
            codeAndDesc.put(enumE.getCode(), enumE);
        }
    }

    CompanyWalletSourceEnum(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

    public static CompanyWalletSourceEnum get(Integer code) {
        for(CompanyWalletSourceEnum enumE : CompanyWalletSourceEnum.values()) {
            if (enumE.getCode().equals(code)) {
                return enumE;
            }
        }
        return null;
    }
}