package com.xxfc.platform.vehicle.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Date;

@Data
@Table(name = "vehicle")
public class  Vehicle {
    /**
     * 1--房车、2--机车、3--游艇、4--豪车
     */
    public static final int GOODS_TYPE_RV = 1;
    public static final int GOODS_TYPE_HM = 2;
    public static final int GOODS_TYPE_YACHT = 3;
    public static final int GOODS_TYPE_LUXURY = 3;

    public static final int STATE_UP = 1;
    public static final int STATE_DOWN = 2;

    public static final int PRICE_TYPE_DAY = 1;
    public static final int PRICE_TYPE_HOUR = 2;

    /**
     * 主键(uuid)
     */
    @Id
    private String id;

    /**
     * 车辆编号，0-没有
     */
    private Integer code;

    /**
     * 车辆状态： 1-正常运行 2-维修 3-报废
     */
    private Integer status;

    /**
     * 车牌号，空字符串-没有
     */
    @Column(name = "number_plate")
    private String numberPlate;


    @ApiModelProperty("商品名称")
    private String name;



    @Column(name = "goods_type")
    @ApiModelProperty("商品类型 1--房车；2--机车；3--游艇")
    private Integer goodsType;


    @ApiModelProperty("品牌（编码，对应关系见相关常量）")
    private Integer brand;


    @Column(name = "brand_id")
    @ApiModelProperty("品牌id")
    private Integer brandId;



    @Column(name = "category_id")
    @ApiModelProperty("型号id")
    private Integer categoryId;

    /**
     * 所属分支机构（id）
     */
    @Column(name = "subordinate_branch")
    private Integer subordinateBranch;



    @ApiModelProperty("封面")
    private String cover;


    @ApiModelProperty("banner图，逗号隔开")
    private String images;



    @Column(name = "price_type")
    @ApiModelProperty("价格类型：1-按天；2-按小时")
    private Integer priceType;



    @ApiModelProperty("价格")
    private BigDecimal price;



    @Column(name = "holiday_price")
    @ApiModelProperty("假日价格")
    private BigDecimal holidayPrice;


    @Column(name = "deposit_type")
    @ApiModelProperty("押金类型：1-线上；2-线下")
    private Integer depositType;

    @ApiModelProperty("押金")
    private BigDecimal deposit;



    @Column(name = "vio_deposit")
    @ApiModelProperty("违章押金")
    private BigDecimal vioDeposit;


    /**
     * 备注信息
     */
    private String remark;


    @ApiModelProperty("实物图片(逗开隔开)")
    private String picture;



    @ApiModelProperty("商品标签(逗号隔开)")
    private String tags;



    /**
     * 用途类型：租赁房车（1）、展车等，对应关系见车辆常量表
     */
    @Column(name = "use_type")
    private Integer useType;



    /**
     * 车架号
     */
    private String vin;

    /**
     * 保险公司，见常量表
     */
    private Integer insuranceCompany;

    private Integer strongInsuranceCompany;

    /**
     * 电子保单
     */
    @Column(name = "insurance_pdf")
    private String insurancePDF;


    /**
     * 保险单号
     */
    private String insuranceNo;
    /**
     * 强险单号
     */
    private String strongInsuranceNo;

    /**
     * 保险开始时间
     */
    private Date insuranceStartDate;

    /**
     * 保险结束时间
     */
    private Date insuranceEndDate;

    /**
     * 强险的结束时间
     */
    private Date strongInsuranceEndDate;

    /**
     * 年审时间
     */
    private Date annualVerificationDate;

    /**
     * 保养时间
     */
    private Date maintenanceDate;

    /**
     * 保养里程数
     */
    private Integer maintenanceMileage;

    /**
     * 车辆所属人-类型
     */
    private Integer belongTo;

    /**
     * 所属人 名称
     */
    private String belongToName;

    /**
     * 行驶证路径
     */
    private String drivingLicensePath;

    /**
     *行驶证副本
     */
    private String drivingLicenseDuplicatePath;

    /**
     * 发动机号
     */
    private String engineNum;

    /**
     * 生产商
     */
    private String manufacturer;

    /**
     * 收车时间
     */
    private Date receiveTime;

    /**
     * 最后更新里程数
     */
    private Integer mileageLastUpdate;
    /**
     * 经营分公司（id）
     */
    @Column(name = "manage_company_id")
    private Integer manageCompanyId;
    /**
     * 停车分公司（id）
     */
    @Column(name = "park_branch_company_id")
    private Integer parkBranchCompanyId;
    /**
     * 预计目的地分公司id
     */
    private Integer expectDestinationBranchCompanyId;
    /**
     * 车型id
     */
    @Column(name = "model_id")
    private Integer modelId;

    /**
     * 车辆当前出行状态： 1-出行中 2-预约中 3-空闲中 4-保养中
     */
    @Column(name = "travel_status")
    private Integer travelStatus;

    /**
     * 终端号
     */
    @Column(name = "terminal_number")
    private String terminalNumber;

    /**
     * SIM卡号
     */
    @Column(name = "sim_number")
    private String simNumber;

    /**
     * 通讯类型
     */
    @Column(name = "communication_type")
    private String communicationType;

    /**
     * 是否删除；0-正常；1-删除
     */
    private Integer isDel;

    /**
     * 是否能用会员：1、所有会员，2、充值会员，3、兑换会员，4、禁用会员
     */
    @Column(name = "member_use")
    private Integer memberUse;

    /**
     * 车辆状况：1、全新，2、9成新，3、8成新，4、7成新
     */
    @Column(name = "vehicle_status")
    private Integer vehicleStatus;

    /**
     * 车身状况：1、无剐蹭，2、微瑕疵，3、无瑕疵
     */
    @Column(name = "vehicle_body_status")
    private Integer vehicleBodyStatus;

    /**
     * 内饰：1、全新，2、9成新，3、8成新，4、7成新
     */
    @Column(name = "vehicle_inner_status")
    private Integer vehicleInnerStatus;

    @Column(name = "vehicle_register_date")
    private Date vehicleRegisterDate;




    @ApiModelProperty("状态：1-上架；2-下架")
    private Integer state;


    @Transient
    @ApiModelProperty("扩展信息list")
    private String extensionList;

    @Transient
    @ApiModelProperty("申请id")
    private Integer vehicleApplyId;

}