package com.github.wxiaoqi.security.admin.biz;


import com.github.wxiaoqi.security.admin.dto.CompanyWalletDTO;
import com.github.wxiaoqi.security.admin.dto.WalletDetailDTO;
import com.github.wxiaoqi.security.admin.entity.CompanyWallet;
import com.github.wxiaoqi.security.admin.mapper.CompanyWalletMapper;
import com.github.wxiaoqi.security.admin.vo.CompanyWalletVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;


@Service
@Slf4j
public class CompanyWalletBiz extends BaseBiz<CompanyWalletMapper, CompanyWallet>{



    public void  updCompanyWallet(CompanyWallet companyWallet){
        mapper.updMyWater(companyWallet);
    }

    public CompanyWallet  sumAmount(WalletDetailDTO walletDetailDTO){
        return  mapper.sumAmount(walletDetailDTO);
    }


    //检查提现下一步操作
    public CompanyWallet checkAmount(Integer companyId, BigDecimal amount) {
        if (amount.compareTo(BigDecimal.ZERO) < 1) {
            throw  new BaseException("提现金额不能小于0", ResultCode.FAILED_CODE);
        }
        CompanyWallet companyWallet =selectById(companyId);
        if (companyWallet == null) {
             throw  new BaseException( "钱包不存在",ResultCode.FAILED_CODE);
        }

        if (amount.compareTo(companyWallet.getBalance()) > 0) {
            throw  new BaseException("提现金额不能大于钱包金额和未审核提现金额",ResultCode.FAILED_CODE);
        }

        return  companyWallet;
    }


    public List<CompanyWalletVo> getList(CompanyWalletDTO walletDTO){
        return  mapper.selectList(walletDTO);
    }


    public PageDataVO<CompanyWalletVo> selectList(CompanyWalletDTO walletDTO) {
        return PageDataVO.pageInfo(walletDTO.getPage(), walletDTO.getLimit(), () -> getList(walletDTO));
    }

    public  CompanyWalletVo  info(CompanyWalletDTO walletDTO){
        List<CompanyWalletVo> list = mapper.selectList(walletDTO);
        if (list.size() > 0) {
            CompanyWalletVo companyWalletVo = list.get(0);
            companyWalletVo.setTodayAmount(mapper.todayAmount(companyWalletVo.getCompanyId()));
            companyWalletVo.setNotDoAmount(mapper.notDoAmount(companyWalletVo.getCompanyId()));
            companyWalletVo.setMonthAmount(mapper.monthAmount(companyWalletVo.getCompanyId(),walletDTO.getMonth()));
            return companyWalletVo;
        }

        return  null;
    }





}
