package com.github.wxiaoqi.security.admin.biz;



import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.admin.dto.BranchCompanyBannerDTO;
import com.github.wxiaoqi.security.admin.entity.*;
import com.github.wxiaoqi.security.admin.mapper.BranchCompanyBannerMapper;
import com.github.wxiaoqi.security.admin.vo.BranchCompanyBannerVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import java.util.List;


@Service
@Slf4j
public class BranchCompanyBannerBiz extends BaseBiz<BranchCompanyBannerMapper, BranchCompanyBanner>{





    public List<BranchCompanyBannerVo> getList(BranchCompanyBannerDTO branchCompanyBannerDTO){
        return  mapper.selectList(branchCompanyBannerDTO);
    }

    public ObjectRestResponse selectList(BranchCompanyBannerDTO branchCompanyBannerDTO){
        PageHelper.startPage(branchCompanyBannerDTO.getPage(), branchCompanyBannerDTO.getLimit());
        PageInfo<BranchCompanyBannerVo> pageInfo = new PageInfo<>(getList(branchCompanyBannerDTO));
        return ObjectRestResponse.succ(PageDataVO.pageInfo(pageInfo));
    }


}
