package com.github.wxiaoqi.security.admin.biz;



import com.github.wxiaoqi.security.admin.dto.BaseOrderRevenueFindDTO;
import com.github.wxiaoqi.security.admin.dto.OrderWaterDTO;
import com.github.wxiaoqi.security.admin.entity.*;
import com.github.wxiaoqi.security.admin.mapper.BaseOrderRevenueMapper;
import com.github.wxiaoqi.security.admin.vo.BaseOrderRevenueVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


@Service
@Slf4j
public class BaseOrderRevenueBiz extends BaseBiz<BaseOrderRevenueMapper, BaseOrderRevenue>{


    @Autowired
    BaseOrderAcceptDetailedBiz acceptDetailedBiz;

    @Autowired
    CompanyWalletDetailBiz walletDetailBiz;



    public void addOrUpd(BaseOrderRevenue baseOrderRevenue){
        BaseOrderRevenue baseOrderRevenue1 = mapper.infoByOrderNo(baseOrderRevenue.getOrderNo(), baseOrderRevenue.getType(),baseOrderRevenue.getCompanyId());
        if (baseOrderRevenue1 == null ){
            insertSelective(baseOrderRevenue);
        }else {
            baseOrderRevenue.setId(baseOrderRevenue1.getId());
            updateSelectiveById(baseOrderRevenue);
        }
    }


    public  void  saveRevenue(OrderWaterDTO orderWaterDTO){
        List<BaseOrderRevenue> list = acceptDetailedBiz.getListByRevenue(orderWaterDTO);
        if (list.size() > 0){
            for (BaseOrderRevenue baseOrderRevenue : list){
                setTypes(baseOrderRevenue);
                addOrUpd(baseOrderRevenue);
            }
        }
    }


    public void  setTypes(BaseOrderRevenue baseOrderRevenue){
        String type = baseOrderRevenue.getType();
        if (StringUtils.isNotBlank(type)){
            List<String> types = new ArrayList<>();
            String[] split = type.split(",");
            for (int i = 0; i < split.length; i++){
                types.add(walletDetailBiz.setItype(Integer.parseInt(split[0]))+"");
            }
            baseOrderRevenue.setType(String.join(",",types));
        }
    }


    public PageDataVO<BaseOrderRevenueVo> selectList(BaseOrderRevenueFindDTO revenueFindDTO) {
        return PageDataVO.pageInfo(revenueFindDTO.getPage(), revenueFindDTO.getLimit(), () -> getList(revenueFindDTO));
    }

    public List<BaseOrderRevenueVo> getList(BaseOrderRevenueFindDTO revenueFindDTO){
        return  mapper.selectList(revenueFindDTO);
    }


    public BigDecimal sumAmount(BaseOrderRevenueFindDTO revenueFindDTO){
        return  mapper.sumAmount(revenueFindDTO);
    }




}
