package com.github.wxiaoqi.security.common.util;


import cn.hutool.core.lang.Assert;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;

public abstract class BeanUtils extends org.springframework.beans.BeanUtils {

    public static void copyPropertiesTargetIsEquals(Object source, Object target) throws BeansException {
        Assert.notNull(source, "Source must not be null");
        Assert.notNull(target, "Target must not be null");
        Class<?> actualEditable = target.getClass();
        PropertyDescriptor[] targetPds = getPropertyDescriptors(actualEditable);
        for (PropertyDescriptor targetPd : targetPds) {
            if (targetPd.getWriteMethod() != null) {
                PropertyDescriptor sourcePd = getPropertyDescriptor(source.getClass(), targetPd.getName());
                if (sourcePd != null && sourcePd.getReadMethod() != null) {
                    try {
                        Method readMethod = sourcePd.getReadMethod();
                        if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                            readMethod.setAccessible(true);
                        }
                        Object value = readMethod.invoke(source);
                        // 这里判断以下value是否为空 当然这里也能进行一些特殊要求的处理 例如绑定时格式转换等等
                        if (value != null ) {
                            Method writeMethod = targetPd.getWriteMethod();
                            if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                                writeMethod.setAccessible(true);
                            }
                            Method readMethod1 = targetPd.getReadMethod();
                            if (!Modifier.isPublic(readMethod1.getDeclaringClass().getModifiers())) {
                                readMethod1.setAccessible(true);
                            }
                            Object targetValue = readMethod1.invoke(target);
                            if (value != null && targetValue != null ){
                                if (targetValue instanceof BigDecimal && value instanceof BigDecimal){
                                    BigDecimal a1 = (BigDecimal) targetValue;
                                    BigDecimal a2 = (BigDecimal) value;
                                    if (a1.compareTo(a2) == 0){
                                        writeMethod.invoke(target,  (String)null);
                                    }
                                }else if ( value.equals(targetValue)){
                                    writeMethod.invoke(target,  (String)null);
                                }
                            }

                        }
                    } catch (Throwable ex) {
                        throw new FatalBeanException("Could not copy properties from source to target", ex);
                    }
                }
            }
        }
    }

    public static void copyPropertiesTargetIsNull(Object source, Object target) throws BeansException {
        Assert.notNull(source, "Source must not be null");
        Assert.notNull(target, "Target must not be null");
        Class<?> actualEditable = target.getClass();
        PropertyDescriptor[] targetPds = getPropertyDescriptors(actualEditable);
        for (PropertyDescriptor targetPd : targetPds) {
            if (targetPd.getWriteMethod() != null) {
                PropertyDescriptor sourcePd = getPropertyDescriptor(source.getClass(), targetPd.getName());
                if (sourcePd != null && sourcePd.getReadMethod() != null) {
                    try {
                        Method readMethod = sourcePd.getReadMethod();
                        if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                            readMethod.setAccessible(true);
                        }
                        Object value = readMethod.invoke(source);
                        // 这里判断以下value是否为空 当然这里也能进行一些特殊要求的处理 例如绑定时格式转换等等
                        if (value != null ) {
                            Method writeMethod = targetPd.getWriteMethod();
                            if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                                writeMethod.setAccessible(true);
                            }
                            Method readMethod1 = targetPd.getReadMethod();
                            if (!Modifier.isPublic(readMethod1.getDeclaringClass().getModifiers())) {
                                readMethod1.setAccessible(true);
                            }
                            Object targetValue = readMethod1.invoke(target);
                            if (targetValue == null ){
                                writeMethod.invoke(target, value);
                            }

                        }
                    } catch (Throwable ex) {
                        throw new FatalBeanException("Could not copy properties from source to target", ex);
                    }
                }
            }
        }
    }
}
