package com.github.wxiaoqi.security.common.rest;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.msg.TableResultResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.ReflectionUtils;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-15 8:48
 */
@Slf4j
public class BaseController<Biz extends BaseBiz,Entity> extends CommonBaseController{
    public static Logger getLog() {
        return log;
    }

    @Autowired
    protected Biz baseBiz;

    public Biz getBaseBiz() {
        return baseBiz;
    }

    @ApiOperation("添加")
    @RequestMapping(value = "",method = RequestMethod.POST)
    @ResponseBody
    public ObjectRestResponse<Entity> add(@RequestBody Entity entity) {
        baseBiz.insertSelective(entity);
        return new ObjectRestResponse<Entity>();
    }

    @ApiOperation("查询")
    @RequestMapping(value = "/{id}",method = RequestMethod.GET)
    @ResponseBody
    public ObjectRestResponse<Entity> get(@PathVariable int id){
        ObjectRestResponse<Entity> entityObjectRestResponse = new ObjectRestResponse<>();
        Object o = baseBiz.selectById(id);
        entityObjectRestResponse.data((Entity)o);
        return entityObjectRestResponse;
    }

    @ApiOperation("修改")
    @RequestMapping(value = "/{id}",method = RequestMethod.PUT)
    @ResponseBody
    public ObjectRestResponse<Entity> update(@RequestBody Entity entity) throws Exception {
        baseBiz.updateSelectiveById(entity);
        return new ObjectRestResponse<Entity>();
    }

    @ApiOperation("修改")
    @RequestMapping(value = "/",method = RequestMethod.PUT)
    @ResponseBody
    public ObjectRestResponse<Entity> update2(@RequestBody Entity entity) throws Exception {
        baseBiz.updateSelectiveById(entity);
        return new ObjectRestResponse<Entity>();
    }

    @ApiOperation("删除")
    @RequestMapping(value = "/{id}",method = RequestMethod.DELETE)
    @ResponseBody
    public ObjectRestResponse<Entity> remove(@PathVariable int id){
        baseBiz.deleteById(id);
        return new ObjectRestResponse<Entity>();
    }

    @ApiOperation("查询所有")
    @RequestMapping(value = "/all",method = RequestMethod.GET)
    @ResponseBody
    public List<Entity> all() {
        return baseBiz.selectListAll();
    }

    @ApiOperation("查询分页")
    @RequestMapping(value = "/page",method = RequestMethod.GET)
    @ResponseBody
    public TableResultResponse<Entity> list(@RequestParam Map<String, Object> params){
        //查询列表数据
        Query query = new Query(params);
        return baseBiz.selectPageByQuery(query);
    }

    @ApiOperation("根据参数查询，等于")
    @RequestMapping(value = "/entityList",method = RequestMethod.GET)
    @ResponseBody
    public ObjectRestResponse<List<Entity>> entityList(Entity entity){
        //查询列表数据
        return ObjectRestResponse.succ(baseBiz.selectList(entity));
    }

    @ApiOperation("根据参数查询，等于")
    @RequestMapping(value = "/entityListPost",method = RequestMethod.POST)
    @ResponseBody
    public ObjectRestResponse<List<Entity>> entityListPost(@RequestBody Entity entity){
        //查询列表数据
        return ObjectRestResponse.succ(baseBiz.selectList(entity));
    }
//
//    @ApiOperation("根据参数查询，等于")
//    @RequestMapping(value = "/entityListPost",method = RequestMethod.POST)
//    @ResponseBody
//    public ObjectRestResponse<List<Entity>> entityListPost(@RequestBody Entity entity){
//        //查询列表数据
//        return ObjectRestResponse.succ(baseBiz.selectList(entity));
//    }

    @ApiOperation("查询所有")
    @RequestMapping(value = "/alls",method = RequestMethod.GET)
    @ResponseBody
    public ObjectRestResponse alls(Entity entity){
        return ObjectRestResponse.succ(baseBiz.selectListAlls(entity));
    }


    @ApiOperation("删除")
    @RequestMapping(value = "/del",method = RequestMethod.DELETE)
    @ResponseBody
    public ObjectRestResponse del( Entity entity){
        Field field = ReflectionUtils.getAccessibleField(entity, "isDel");
        Field field2 = ReflectionUtils.getAccessibleField(entity, "delete");

        if(null != field) {
            ReflectionUtils.setFieldValue(entity,"isDel",1);
        }
        if(null != field2) {
            ReflectionUtils.setFieldValue(entity,"delete",1);
        }

        baseBiz.updateSelectiveById(entity);
        return ObjectRestResponse.succ();
    }


}
