package com.xxfc.platform.summit.biz;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.summit.entity.Activity;
import com.xxfc.platform.summit.mapper.ActivityMapper;
import com.xxfc.platform.summit.pojo.ActivityQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * @author Administrator
 */
@Service
public class ActivityBiz extends BaseBiz<ActivityMapper, Activity> {

     private Integer NOT_DELETE=0;

    public PageInfo<Activity> getList(ActivityQuery query) {

        Example exa= new Example(Activity.class);
        Example.Criteria criteria = exa.createCriteria();
        criteria.andEqualTo("isDel",NOT_DELETE );
        if (StringUtils.isNotBlank(query.getTitle())) {
            criteria.andLike("title",query.getTitle());
        }
        if (query.getStartTime()!=null) {
            criteria.andGreaterThanOrEqualTo("startTime",query.getStartTime());
        }
        if (query.getStatus()!=null) {
            criteria.andGreaterThanOrEqualTo("status",query.getStatus());
        }
        exa.orderBy("rank").asc().orderBy("startTime").desc();
        PageHelper.startPage(query.getPage(),query.getLimit());
        List<Activity> activities = mapper.selectByExample(exa);
        return   new PageInfo<Activity>(activities);

    }

    @Transactional(rollbackFor = Exception.class)
    public Boolean update(Activity activity) {
        try {
            activity.setUpdTime(System.currentTimeMillis());
            mapper.updateByPrimaryKeySelective(activity);
           return true;
        } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }

    }
}
