package com.xxfc.platform.order.feign;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.pojo.dto.OrderDTO;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created by ace on 2017/9/15.
 */
@FeignClient(name = "xx-order")
public interface OrderFeign {
    @GetMapping("/baseOrder/count")
    public ObjectRestResponse<Integer> baseOrderCount(@RequestParam("hasMemberRight") Integer hasMemberRight, @RequestParam("multiStatus") String multiStatus, @RequestParam("multiTypes") String multiTypes, @RequestParam("userId") Integer userId);

    @GetMapping("/count/list")
    public ObjectRestResponse<List<OrderPageVO>> getOrderList(@RequestParam("dateTime")Long dateTime, @RequestParam("type")Integer type, @RequestParam("status")Integer status);


     @GetMapping(value = "/count/basebase/findByOrderIds")
     public ObjectRestResponse<List<OrderDTO>> findOrdersByorderId(@RequestParam(value = "orderIds") List<Integer> orderIds);

    @PostMapping(value = "/count/basebase/findOrdersByorderIdV2")
    ObjectRestResponse<List<OrderDTO>> findOrdersByorderIdV2(@RequestBody List<Integer> orderIds);
}
