package com.xxfc.platform.order.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 订单帐目
 * 
 * @author zhoujw
 * @email 18178966185@163.com
 * @date 2019-09-09 15:51:16
 */
@Data
@Table(name = "order_account")
public class OrderAccount implements Serializable {
	private static final long serialVersionUID = 1L;
	
	/**
     *  主键
     */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	/**
     *  订单id
     */
    @Column(name = "order_id")
	@ApiModelProperty(value = "订单id")
    private Integer orderId;
	
	    /**
     *  账款对应的流水号
     */
    @Column(name = "trade_no")
	@ApiModelProperty(value = "账款对应的流水号")
    private String tradeNo;
	
	    /**
     *  记账时间
     */
    @Column(name = "account_time")
	@ApiModelProperty(value = "记账时间")
    private Long accountTime;
	
	    /**
     *  记帐类型 101--订单支付；201--取消订单退款；202--全部押金退款；203--部分押金退款；204--剩余押金退款
     */
    @Column(name = "account_type")
	@ApiModelProperty(value = "记帐类型 101--订单支付；201--取消订单退款；202--全部押金退款；203--部分押金退款；204--剩余押金退款")
    private Integer accountType;
	
	    /**
     *  账款状态 1--成功；2--失败
     */
    @Column(name = "account_status")
	@ApiModelProperty(value = "账款状态 1--成功；2--失败")
    private Integer accountStatus;
	
	    /**
     *  账款金额
     */
    @Column(name = "account_amount")
	@ApiModelProperty(value = "账款金额")
    private BigDecimal accountAmount;
	
	    /**
     *  账款说明
     */
    @Column(name = "account_desc")
	@ApiModelProperty(value = "账款说明")
    private String accountDesc;
	
	    /**
     *  账款详情
     */
    @Column(name = "account_detail")
	@ApiModelProperty(value = "账款详情")
    private String accountDetail;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  原金额
     */
    @Column(name = "original_amount")
	@ApiModelProperty(value = "原金额")
    private BigDecimal originalAmount;
	
	    /**
     *  扣除金额
     */
    @Column(name = "deduct_amount")
	@ApiModelProperty(value = "扣除金额")
    private BigDecimal deductAmount;
	

}
