package com.xxfc.platform.uccn.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.uccn.biz.FriendLinkBiz;
import com.xxfc.platform.uccn.vo.FriendLinkVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/9/6 10:59
 */
@RestController
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@RequestMapping("/app/unauth/friend_link")
@Api(tags = "友情链接*官网")
public class FriendLinkController {

     private final FriendLinkBiz friendLinkBiz;

     @ApiOperation("查询链接列表")
     @GetMapping("/list")
     public ObjectRestResponse<List<FriendLinkVO>> listFriendLink(@RequestParam(value = "platform",required = false,defaultValue = "1") Integer platform){
         List<FriendLinkVO> friendLinkVOS = friendLinkBiz.listFriendLinkByPlatform(platform);
         return ObjectRestResponse.succ(friendLinkVOS);
     }

}
