package com.xxfc.platform.order.rest.background;

import com.github.wxiaoqi.security.common.annotation.SimpleValid;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.biz.OrderReceivedStatisticsBiz;
import com.xxfc.platform.order.pojo.dto.OrderReceivedStatisticsFindDTO;
import com.xxfc.platform.order.pojo.vo.OrderReceivedStatisticsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * @author libin
 * @version 1.0
 * @description 订单统计
 * @data 2019/11/11 9:14
 */
@Api(tags = "订单统计")
@RestController
@RequestMapping("admin/order/received_statistics")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class OrderReceivedStatisticsAdminController {
    private final OrderReceivedStatisticsBiz orderReceivedStatisticsBiz;

     @ApiOperation("订单统计")
     @PostMapping("")
     public ObjectRestResponse<Map<String, List<OrderReceivedStatisticsVo>>> orderReceivedStatistics(@RequestBody @SimpleValid OrderReceivedStatisticsFindDTO orderReceivedStatisticsFindDTO){
         Map<String, List<OrderReceivedStatisticsVo>> orderReceivedStatisticsPageVo = orderReceivedStatisticsBiz.getOrderReceivedStatisticsResult(orderReceivedStatisticsFindDTO);
         return ObjectRestResponse.succ(orderReceivedStatisticsPageVo);
     }
}
