package com.xxfc.platform.order.biz;

import com.xxfc.platform.order.pojo.dto.OrderReceivedStatisticsFindDTO;
import com.xxfc.platform.order.pojo.vo.OrderReceivedStatisticsVo;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xxfc.platform.order.entity.OrderReceivedStatistics;
import com.xxfc.platform.order.mapper.OrderReceivedStatisticsMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 *  全部订单统计
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-11-08 18:03:42
 */
@Service
@Transactional(rollbackFor = Exception.class)
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class OrderReceivedStatisticsBiz extends BaseBiz<OrderReceivedStatisticsMapper,OrderReceivedStatistics> {
      private final OrderRentVehicleReceivedStatisticsBiz orderRentVehicleReceivedStatisticsBiz;
      private final OrderTourReceivedStatisticsBiz orderTourReceivedStatisticsBiz;
      private final OrderMemberReceivedStatisticsBiz orderMemberReceivedStatisticsBiz;

    public Map<String, List<OrderReceivedStatisticsVo>> getOrderReceivedStatisticsResult(OrderReceivedStatisticsFindDTO orderReceivedStatisticsFindDTO) {
        return Collections.EMPTY_MAP;
    }
}