package com.xxfc.platform.order.pojo.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/11 9:49
 */
@Data
@ApiModel("统计查询")
public class OrderReceivedStatisticsFindDTO {
      @ApiModelProperty("统计的开始时间 yyyy-MM-dd")
      private Date startDate;
      @ApiModelProperty("统计的结束时间 yyyy-MM-dd")
      private Date endDate;
      @ApiModelProperty("统计方式 1:日 2:周 3：周")
      @NotNull(message = "统计方式不能为null")
      private Integer statisticalWay;
      @ApiModelProperty("订单状态 0:未完成 1:已完成")
      private Integer orderState;
      @ApiModelProperty("订单来源 1:app 2:小程序 3:后台")
      private Integer orderOrigin;
      @ApiModelProperty("支付方式 1:微信公众号支付 2:支付宝即时到账,3:银联")
      private Integer payWay;
      @ApiModelProperty("统计项标识")
      @NotNull(message = "统计标识不能为null")
      private List<Integer> statisticalSigns;
}
