package com.xxfc.platform.order.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 租车订单统计
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-11-08 18:03:42
 */
@Data
@Table(name = "order_rent_vehicle_received_statistics")
public class OrderRentVehicleReceivedStatistics extends OrderReceivedStatisticsBase implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("")
    private Long id;

    /**
     * 订单总额
     */
    @Column(name = "total_amount")
    @ApiModelProperty(value = "订单总额")
    private BigDecimal totalAmount;

    /**
     * 订单总量
     */
    @Column(name = "total_quantity")
    @ApiModelProperty(value = "订单总量")
    private Integer totalQuantity;

    /**
     * 订单平均量
     */
    @Column(name = "avg_quantity")
    @ApiModelProperty(value = "订单平均量")
    private Integer avgQuantity;

    /**
     * 实际收入
     */
    @Column(name = "real_amount")
    @ApiModelProperty(value = "实际收入")
    private BigDecimal realAmount;

    /**
     * 实际平均收入
     */
    @Column(name = "real_avg_amount")
    @ApiModelProperty(value = "实际平均收入")
    private BigDecimal realAvgAmount;

    /**
     * 是否完成 1 完成  0 未完成
     */
    @Column(name = "is_finish")
    @ApiModelProperty(value = "是否完成 1 完成  0 未完成")
    private Integer isFinish;

    /**
     * '支付来源 1--app；2--小程序',
     */
    @Column(name = "order_origin")
    @ApiModelProperty(value = " '支付来源 1--app；2--小程序',")
    private Integer orderOrigin;

    /**
     * 支付方式 '1:微信公众号支付 2.支付宝即时到账,3,银联'
     */
    @Column(name = "pay_way")
    @ApiModelProperty(value = "支付方式 '1:微信公众号支付 2.支付宝即时到账,3,银联'")
    private Integer payWay;

    /**
     * 公司id
     */
    @Column(name = "company_id")
    @ApiModelProperty(value = "公司id")
    private Integer companyId;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    @ApiModelProperty(value = "创建时间", hidden = true)
    private Date crtTime;


}
