package com.xxfc.platform.order.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 会员订单统计
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-11-08 18:03:42
 */
@Data
@Table(name = "order_member_received_statistics")
public class OrderMemberReceivedStatistics extends OrderReceivedStatisticsBase implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("")
    private Long id;

    /**
     * 订单总额
     */
    @Column(name = "total_amount")
    @ApiModelProperty(value = "订单总额")
    private BigDecimal totalAmount;

    /**
     * 普通会员订单总额
     */
    @Column(name = "toal_common_ammount")
    @ApiModelProperty(value = "普通会员订单总额")
    private BigDecimal toalCommonAmmount;

    /**
     * 普通会员订单总量
     */
    @Column(name = "total_common_quantity")
    @ApiModelProperty(value = "普通会员订单总量")
    private Integer totalCommonQuantity;

    /**
     * 黄金会员订单总额
     */
    @Column(name = "total_gold_amount")
    @ApiModelProperty(value = "黄金会员订单总额")
    private BigDecimal totalGoldAmount;

    /**
     * 黄金会员订单总量
     */
    @Column(name = "total_gold_quantity")
    @ApiModelProperty(value = "黄金会员订单总量")
    private Integer totalGoldQuantity;

    /**
     * 钻石会员订单总额
     */
    @Column(name = "total_diamond_ammount")
    @ApiModelProperty(value = "钻石会员订单总额")
    private BigDecimal totalDiamondAmmount;

    /**
     * 钻石会员订单总量
     */
    @Column(name = "total_diamond_quantity")
    @ApiModelProperty(value = "钻石会员订单总量")
    private Integer totalDiamondQuantity;

    /**
     * 是否完成 1 完成  0 未完成
     */
    @Column(name = "is_finish")
    @ApiModelProperty(value = "是否完成 1 完成  0 未完成")
    private Integer isFinish;

    /**
     * '支付来源 1--app；2--小程序',
     */
    @Column(name = "order_origin")
    @ApiModelProperty(value = " '支付来源 1--app；2--小程序',")
    private Integer orderOrigin;

    /**
     * 支付方式 '1:微信公众号支付 2.支付宝即时到账,3,银联'
     */
    @Column(name = "pay_way")
    @ApiModelProperty(value = "支付方式 '1:微信公众号支付 2.支付宝即时到账,3,银联'")
    private Integer payWay;

    /**
     * 公司id
     */
    @Column(name = "company_id")
    @ApiModelProperty(value = "公司id")
    private Integer companyId;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    @ApiModelProperty(value = "创建时间", hidden = true)
    private Date crtTime;


}
