package com.xxfc.platform.order.contant.enumerate;

import com.xxfc.platform.order.entity.OrderReceivedStatisticsBase;
import com.xxfc.platform.order.entity.OrderRentVehicleReceivedStatistics;
import com.xxfc.platform.order.pojo.vo.OrderReceivedStatisticsVo;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/11 15:25
 */
public enum ReceivedStatisticsEnum {
    DAY(1, "按日统计") {
        @Override
        Map<Object, List<OrderReceivedStatisticsBase>> wrapMap(List<OrderReceivedStatisticsBase> orderReceivedStatisticsBases) {
            if (CollectionUtils.isEmpty(orderReceivedStatisticsBases)) {
                return Collections.EMPTY_MAP;
            }
            return orderReceivedStatisticsBases.stream().collect(Collectors.groupingBy(OrderReceivedStatisticsBase::getDate, Collectors.toList()));
        }
    },
    WEEK(2, "按周统计") {
        @Override
        Map<Object, List<OrderReceivedStatisticsBase>> wrapMap(List<OrderReceivedStatisticsBase> orderReceivedStatisticsBases) {
            if (CollectionUtils.isEmpty(orderReceivedStatisticsBases)) {
                return Collections.EMPTY_MAP;
            }
            return orderReceivedStatisticsBases.stream().collect(Collectors.groupingBy(OrderReceivedStatisticsBase::getWeekOfYear, Collectors.toList()));
        }
    },
    MONTH(3, "按月统计") {
        @Override
        Map<Object, List<OrderReceivedStatisticsBase>> wrapMap(List<OrderReceivedStatisticsBase> orderReceivedStatisticsBases) {
            if (CollectionUtils.isEmpty(orderReceivedStatisticsBases)) {
                return Collections.EMPTY_MAP;
            }
            return orderReceivedStatisticsBases.stream().collect(Collectors.groupingBy(OrderReceivedStatisticsBase::getMonth, Collectors.toList()));
        }
    };
    private int wayCode;
    private String value;

    ReceivedStatisticsEnum(int wayCode, String value) {
        this.wayCode = wayCode;
        this.value = value;
    }

    /**
     * 统计方式
     * @param orderReceivedStatisticsBases
     * @return
     */
    abstract Map<Object, List<OrderReceivedStatisticsBase>> wrapMap(List<OrderReceivedStatisticsBase> orderReceivedStatisticsBases);

    public static OrderReceivedStatisticsVo createOrderReceivedStatistics(OrderReceivedStatisticsBase orderReceivedStatisticsBase, BigDecimal amount,Integer quantity){
        return OrderReceivedStatisticsVo.builder()
                .date(orderReceivedStatisticsBase.getDate())
                .month(orderReceivedStatisticsBase.getMonth())
                .weekOfYear(orderReceivedStatisticsBase.getWeekOfYear())
                .weekOfYear(orderReceivedStatisticsBase.getYear())
                .orderNum(quantity)
                .orderAmount(amount)
                .build();
    }

}
