package com.xxfc.platform.order.contant.enumerate;

import com.xxfc.platform.order.entity.OrderReceivedStatisticsBase;
import com.xxfc.platform.order.entity.OrderTourReceivedStatistics;
import com.xxfc.platform.order.pojo.vo.OrderReceivedStatisticsVo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/11 10:36
 */
public enum OrderTourReceivedStatisticsSignEnum {
     TOUR_TOTAL_AMOUNT("tta","旅游订单总额"){
          @Override
          Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
               Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
               List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
               orderMap.forEach((K,V)->{
                    List<OrderTourReceivedStatistics> orderTourReceivedStatisticsList = V.stream().map(x -> (OrderTourReceivedStatistics) x).collect(Collectors.toList());
                    BigDecimal totalAmount = orderTourReceivedStatisticsList.stream().map(x -> x.getTotalAmount()).reduce(BigDecimal.ZERO, (x, y) -> x.add(y));
                    OrderTourReceivedStatistics orderReceivedStatistics = orderTourReceivedStatisticsList.get(0);
                    OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderReceivedStatistics,totalAmount,null);
                    orderReceivedStatisticsVos.add(receivedStatisticsVo);
               });
               resultMap.put(getSign(),orderReceivedStatisticsVos);
               return resultMap;
          }
     },
     TOUR_TOTAL_QUANTITY("ttq","旅游订单量"){
          @Override
          Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
               Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
               List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
               orderMap.forEach((K,V)->{
                    List<OrderTourReceivedStatistics> orderTourReceivedStatisticsList = V.stream().map(x -> (OrderTourReceivedStatistics) x).collect(Collectors.toList());
                    Integer totalQuantity = orderTourReceivedStatisticsList.stream().map(x -> x.getTotalQuantity()).reduce(0, (x, y) -> x+y);
                    OrderTourReceivedStatistics orderReceivedStatistics = orderTourReceivedStatisticsList.get(0);
                    OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderReceivedStatistics,null,totalQuantity);
                    orderReceivedStatisticsVos.add(receivedStatisticsVo);
               });
               resultMap.put(getSign(),orderReceivedStatisticsVos);
               return resultMap;
          }
     },
     TOUR_AVG_QUANTITY("tavgq","旅游订单平均量"){
          @Override
          Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
               Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
               List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
               orderMap.forEach((K,V)->{
                    List<OrderTourReceivedStatistics> orderTourReceivedStatisticsList = V.stream().map(x -> (OrderTourReceivedStatistics) x).collect(Collectors.toList());
                    Integer avgQuantity = orderTourReceivedStatisticsList.stream().map(x -> x.getAvgQuantity()).reduce(0, (x, y) -> x+y)/V.size();
                    OrderTourReceivedStatistics orderReceivedStatistics = orderTourReceivedStatisticsList.get(0);
                    OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderReceivedStatistics,null,avgQuantity);
                    orderReceivedStatisticsVos.add(receivedStatisticsVo);
               });
               resultMap.put(getSign(),orderReceivedStatisticsVos);
               return resultMap;
          }
     };
    private String sign;
    private String desc;

     OrderTourReceivedStatisticsSignEnum(String sign, String desc) {
          this.sign = sign;
          this.desc = desc;
     }
     /**
      * 统计项
      * @param orderMap
      * @return
      */
     abstract Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object,List<OrderReceivedStatisticsBase>> orderMap);

     public String getSign() {
          return sign;
     }

     public void setSign(String sign) {
          this.sign = sign;
     }

     public String getDesc() {
          return desc;
     }

     public void setDesc(String desc) {
          this.desc = desc;
     }
}
