package com.xxfc.platform.order.contant.enumerate;

import com.xxfc.platform.order.entity.OrderReceivedStatisticsBase;
import com.xxfc.platform.order.entity.OrderRentVehicleReceivedStatistics;
import com.xxfc.platform.order.pojo.vo.OrderReceivedStatisticsVo;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/11 10:36
 */
public enum OrderRentVehicleReceivedStatisticsSignEnum{
     RENT_VEHICLE_TOTAL_AMOUNT("rvta","租车订单总额"){
         @Override
         Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
             Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
             List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
             orderMap.forEach((K,V)->{
                 List<OrderRentVehicleReceivedStatistics> orderRentVehicleReceivedStatisticsList = V.stream().map(x -> (OrderRentVehicleReceivedStatistics) x).collect(Collectors.toList());
                 BigDecimal totalAmount = orderRentVehicleReceivedStatisticsList.stream().map(x -> x.getTotalAmount()).reduce(BigDecimal.ZERO, (x, y) -> x.add(y));
                 OrderRentVehicleReceivedStatistics orderReceivedStatistics = orderRentVehicleReceivedStatisticsList.get(0);
                 OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderReceivedStatistics,totalAmount,null);
                 orderReceivedStatisticsVos.add(receivedStatisticsVo);
             });
             resultMap.put(getSign(),orderReceivedStatisticsVos);
             return resultMap;
         }
     },
     RENT_VEHICLE_TOTAL_QUANTITY("rvtq","租车订单量") {
         @Override
         Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
             Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
             List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
             orderMap.forEach((K,V)->{
                 List<OrderRentVehicleReceivedStatistics> orderRentVehicleReceivedStatisticsList = V.stream().map(x -> (OrderRentVehicleReceivedStatistics) x).collect(Collectors.toList());
                 Integer totalQuantity = orderRentVehicleReceivedStatisticsList.stream().map(x -> x.getTotalQuantity()).reduce(0, (x, y) -> x+y);
                 OrderRentVehicleReceivedStatistics orderReceivedStatistics = orderRentVehicleReceivedStatisticsList.get(0);
                 OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderReceivedStatistics,null,totalQuantity);
                 orderReceivedStatisticsVos.add(receivedStatisticsVo);
             });
             resultMap.put(getSign(),orderReceivedStatisticsVos);
             return resultMap;
         }
     },
     RENT_VEHICLE_AVG_QUANTITY("rvaq","租车订单平均量") {
         @Override
         Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
             Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
             List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
             orderMap.forEach((K,V)->{
                 List<OrderRentVehicleReceivedStatistics> orderRentVehicleReceivedStatisticsList = V.stream().map(x -> (OrderRentVehicleReceivedStatistics) x).collect(Collectors.toList());
                 Integer avgQuantity = orderRentVehicleReceivedStatisticsList.stream().map(x -> x.getAvgQuantity()).reduce(0, (x, y) -> x+y)/V.size();
                 OrderRentVehicleReceivedStatistics orderReceivedStatistics = orderRentVehicleReceivedStatisticsList.get(0);
                 OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderReceivedStatistics,null,avgQuantity);
                 orderReceivedStatisticsVos.add(receivedStatisticsVo);
             });
             resultMap.put(getSign(),orderReceivedStatisticsVos);
             return resultMap;
         }
     },
     RENT_VEHICLE_REAL_TOTAL_AMOUNT("rvrta","实际租车金额") {
         @Override
         Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
             Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
             List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
             orderMap.forEach((K,V)->{
                 List<OrderRentVehicleReceivedStatistics> orderRentVehicleReceivedStatisticsList = V.stream().map(x -> (OrderRentVehicleReceivedStatistics) x).collect(Collectors.toList());
                 BigDecimal realAmount = orderRentVehicleReceivedStatisticsList.stream().map(x -> x.getRealAmount()).reduce(BigDecimal.ZERO, (x, y) -> x.add(y));
                 OrderRentVehicleReceivedStatistics orderReceivedStatistics = orderRentVehicleReceivedStatisticsList.get(0);
                 OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderReceivedStatistics,realAmount,null);
                 orderReceivedStatisticsVos.add(receivedStatisticsVo);
             });
             resultMap.put(getSign(),orderReceivedStatisticsVos);
             return resultMap;
         }
     },
     RENT_VEHICLE_REAL_AVG_AMOUNT("rvraa","实际租车平均金额") {
         @Override
         Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
             Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
             List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
             orderMap.forEach((K,V)->{
                 List<OrderRentVehicleReceivedStatistics> orderRentVehicleReceivedStatisticsList = V.stream().map(x -> (OrderRentVehicleReceivedStatistics) x).collect(Collectors.toList());
                 BigDecimal realAvgAmount = orderRentVehicleReceivedStatisticsList.stream().map(x -> x.getRealAvgAmount()).reduce(BigDecimal.ZERO, (x, y) -> x.add(y)).divide(new BigDecimal(V.size()), RoundingMode.HALF_UP);
                 OrderRentVehicleReceivedStatistics orderReceivedStatistics = orderRentVehicleReceivedStatisticsList.get(0);
                 OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderReceivedStatistics,realAvgAmount,null);
                 orderReceivedStatisticsVos.add(receivedStatisticsVo);
             });
             resultMap.put(getSign(),orderReceivedStatisticsVos);
             return resultMap;
         }
     };
    private String sign;
    private String desc;

     OrderRentVehicleReceivedStatisticsSignEnum(String sign, String desc) {
          this.sign = sign;
          this.desc = desc;
     }
    /**
     * 统计项
     * @param orderMap
     * @return
     */
    abstract Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object,List<OrderReceivedStatisticsBase>> orderMap);

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}

