package com.xxfc.platform.order.contant.enumerate;

import com.xxfc.platform.order.entity.OrderReceivedStatistics;
import com.xxfc.platform.order.entity.OrderReceivedStatisticsBase;
import com.xxfc.platform.order.pojo.vo.OrderReceivedStatisticsVo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/11 10:36
 */
public enum  OrderReceivedStatisticsSignEnum {
     ORDER_TOTAL_AMOUNT("ota","订单总额"){
          @Override
          Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
               Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
               List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
               orderMap.forEach((K,V)->{
                    List<OrderReceivedStatistics> orderReceivedStatisticsList = V.stream().map(x -> (OrderReceivedStatistics) x).collect(Collectors.toList());
                    BigDecimal totalAmount = orderReceivedStatisticsList.stream().map(x -> x.getTotalAmount()).reduce(BigDecimal.ZERO, (x, y) -> x.add(y));
                    OrderReceivedStatistics orderReceivedStatistics = orderReceivedStatisticsList.get(0);
                    OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderReceivedStatistics,totalAmount,null);
                    orderReceivedStatisticsVos.add(receivedStatisticsVo);
               });
               resultMap.put(getSign(),orderReceivedStatisticsVos);
               return resultMap;
          }
     },
     ORDER_TOTAL_QUANTITY("otq","订单量"){
          @Override
          Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
               Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
               List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
               orderMap.forEach((K,V)->{
                    List<OrderReceivedStatistics> orderReceivedStatisticsList = V.stream().map(x -> (OrderReceivedStatistics) x).collect(Collectors.toList());
                    Integer totalQuantity = orderReceivedStatisticsList.stream().map(x -> x.getTotalQuantity()).reduce(0, (x, y) -> x+y);
                    OrderReceivedStatistics orderReceivedStatistics = orderReceivedStatisticsList.get(0);
                    OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderReceivedStatistics,null,totalQuantity);
                    orderReceivedStatisticsVos.add(receivedStatisticsVo);
               });
               resultMap.put(getSign(),orderReceivedStatisticsVos);
               return resultMap;
          }
     },
     ORDER_AVG_QUANTITY("oavgq","订单平均量"){
          @Override
          Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
               Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
               List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
               orderMap.forEach((K,V)->{
                    List<OrderReceivedStatistics> orderReceivedStatisticsList = V.stream().map(x -> (OrderReceivedStatistics) x).collect(Collectors.toList());
                    Integer avgQuantity = orderReceivedStatisticsList.stream().map(x -> x.getAvgQuantity()).reduce(0, (x, y) -> x+y)/V.size();
                    OrderReceivedStatistics orderReceivedStatistics = orderReceivedStatisticsList.get(0);
                    OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderReceivedStatistics,null,avgQuantity);
                    orderReceivedStatisticsVos.add(receivedStatisticsVo);
               });
               resultMap.put(getSign(),orderReceivedStatisticsVos);
               return resultMap;
          }
     },
     ORDER_TOTAL_REAL_AMOUNT("otra","订单实际总额"){
          @Override
          Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
               Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
               List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
               orderMap.forEach((K,V)->{
                    List<OrderReceivedStatistics> orderReceivedStatisticsList = V.stream().map(x -> (OrderReceivedStatistics) x).collect(Collectors.toList());
                    BigDecimal realAmount = orderReceivedStatisticsList.stream().map(x -> x.getRealAmount()).reduce(BigDecimal.ZERO, (x, y) -> x.add(y));
                    OrderReceivedStatistics orderReceivedStatistics = orderReceivedStatisticsList.get(0);
                    OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderReceivedStatistics,realAmount,null);
                    orderReceivedStatisticsVos.add(receivedStatisticsVo);
               });
               resultMap.put(getSign(),orderReceivedStatisticsVos);
               return resultMap;
          }
     },
     ORDER_REAL_AVG_AMOUNT("oravga","订单实际平均总额"){
          @Override
          Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
               Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
               List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
               orderMap.forEach((K,V)->{
                    List<OrderReceivedStatistics> orderReceivedStatisticsList = V.stream().map(x -> (OrderReceivedStatistics) x).collect(Collectors.toList());
                    BigDecimal realAvgAmount = orderReceivedStatisticsList.stream().map(x -> x.getRealAvgAmount()).reduce(BigDecimal.ZERO, (x, y) -> x.add(y)).divide(new BigDecimal(V.size()));
                    OrderReceivedStatistics orderReceivedStatistics = orderReceivedStatisticsList.get(0);
                    OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderReceivedStatistics,realAvgAmount,null);
                    orderReceivedStatisticsVos.add(receivedStatisticsVo);
               });
               resultMap.put(getSign(),orderReceivedStatisticsVos);
               return resultMap;
          }
     };
     private String sign;
     private String desc;

     OrderReceivedStatisticsSignEnum(String sign, String desc) {
          this.sign = sign;
          this.desc = desc;
     }
     /**
      * 统计项
      * @param orderMap
      * @return
      */
     abstract Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object,List<OrderReceivedStatisticsBase>> orderMap);

     public String getSign() {
          return sign;
     }

     public void setSign(String sign) {
          this.sign = sign;
     }

     public String getDesc() {
          return desc;
     }

     public void setDesc(String desc) {
          this.desc = desc;
     }

}
