package com.xxfc.platform.order.contant.enumerate;

import com.xxfc.platform.order.entity.OrderMemberReceivedStatistics;
import com.xxfc.platform.order.entity.OrderReceivedStatisticsBase;
import com.xxfc.platform.order.pojo.vo.OrderReceivedStatisticsVo;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/11 10:36
 */
public enum  OrderMemberReceivedStatisticsSignEnum{
    MEMBER_TOTAL_AMOUNT("mta","会员订单总额"){
        @Override
        Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object,List<OrderReceivedStatisticsBase>> orderMap) {
            Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
            List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
            orderMap.forEach((K,V)->{
                List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = V.stream().map(x -> (OrderMemberReceivedStatistics) x).collect(Collectors.toList());
                BigDecimal totalAmount = orderMemberReceivedStatisticsList.stream().map(x -> x.getTotalAmount()).reduce(BigDecimal.ZERO, (x, y) -> x.add(y));
                OrderMemberReceivedStatistics orderMemberReceivedStatistics = orderMemberReceivedStatisticsList.get(0);
                OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderMemberReceivedStatistics,totalAmount,null);
                orderReceivedStatisticsVos.add(receivedStatisticsVo);
            });
             resultMap.put(getSign(),orderReceivedStatisticsVos);
            return resultMap;
        }
    },
    COMMON__MEMBER_TOTAL_AMOUNT("cmta","普通会员订单总额"){
        @Override
        Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
            Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
            List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
            orderMap.forEach((K,V)->{
                List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = V.stream().map(x -> (OrderMemberReceivedStatistics) x).collect(Collectors.toList());
                BigDecimal totalAmount = orderMemberReceivedStatisticsList.stream().map(x -> x.getToalCommonAmmount()).reduce(BigDecimal.ZERO, (x, y) -> x.add(y));
                OrderMemberReceivedStatistics orderMemberReceivedStatistics = orderMemberReceivedStatisticsList.get(0);
                OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderMemberReceivedStatistics,totalAmount,null);
                orderReceivedStatisticsVos.add(receivedStatisticsVo);
            });
            resultMap.put(getSign(),orderReceivedStatisticsVos);
            return resultMap;
        }
    },
    MEMBER_TOTAL_QUANTITY("cmtq","普通会员订单量"){
        @Override
        Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
            Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
            List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
            orderMap.forEach((K,V)->{
                List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = V.stream().map(x -> (OrderMemberReceivedStatistics) x).collect(Collectors.toList());
                Integer totalQuantity = orderMemberReceivedStatisticsList.stream().map(x -> x.getTotalCommonQuantity()).reduce(0, (x, y) -> x+y);
                OrderMemberReceivedStatistics orderMemberReceivedStatistics = orderMemberReceivedStatisticsList.get(0);
                OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderMemberReceivedStatistics,null,totalQuantity);
                orderReceivedStatisticsVos.add(receivedStatisticsVo);
            });
            resultMap.put(getSign(),orderReceivedStatisticsVos);
            return resultMap;
        }
    },
    GOLD_MEMBER_TOTAL_AMOUNT("gmta","黄金会员订单总额"){
        @Override
        Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
            Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
            List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
            orderMap.forEach((K,V)->{
                List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = V.stream().map(x -> (OrderMemberReceivedStatistics) x).collect(Collectors.toList());
                BigDecimal totalAmount = orderMemberReceivedStatisticsList.stream().map(x -> x.getTotalGoldAmount()).reduce(BigDecimal.ZERO, (x, y) -> x.add(y));
                OrderMemberReceivedStatistics orderMemberReceivedStatistics = orderMemberReceivedStatisticsList.get(0);
                OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderMemberReceivedStatistics,totalAmount,null);
                orderReceivedStatisticsVos.add(receivedStatisticsVo);
            });
            resultMap.put(getSign(),orderReceivedStatisticsVos);
            return resultMap;
        }
    },
    GOLD_MEMBER_TOTAL_QUANTITY("mgtq","黄金会员订单量"){
        @Override
        Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
            Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
            List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
            orderMap.forEach((K,V)->{
                List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = V.stream().map(x -> (OrderMemberReceivedStatistics) x).collect(Collectors.toList());
                Integer totalQuantity = orderMemberReceivedStatisticsList.stream().map(x -> x.getTotalGoldQuantity()).reduce(0, (x, y) -> x+y);
                OrderMemberReceivedStatistics orderMemberReceivedStatistics = orderMemberReceivedStatisticsList.get(0);
                OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderMemberReceivedStatistics,null,totalQuantity);
                orderReceivedStatisticsVos.add(receivedStatisticsVo);
            });
            resultMap.put(getSign(),orderReceivedStatisticsVos);
            return resultMap;
        }
    },
    DIAMOND_MEMBER_TOTAL_AMOUNT("dmta","钻石会员订单总额"){
        @Override
        Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
            Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
            List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
            orderMap.forEach((K,V)->{
                List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = V.stream().map(x -> (OrderMemberReceivedStatistics) x).collect(Collectors.toList());
                BigDecimal totalAmount = orderMemberReceivedStatisticsList.stream().map(x -> x.getTotalDiamondAmmount()).reduce(BigDecimal.ZERO, (x, y) -> x.add(y));
                OrderMemberReceivedStatistics orderMemberReceivedStatistics = orderMemberReceivedStatisticsList.get(0);
                OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderMemberReceivedStatistics,totalAmount,null);
                orderReceivedStatisticsVos.add(receivedStatisticsVo);
            });
            resultMap.put(getSign(),orderReceivedStatisticsVos);
            return resultMap;
        }
    },
    DIAMOND_MEMBER_TOTAL_QUANTITY("dmtq","钻石会员订单量"){
        @Override
        Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
            Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
            List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
            orderMap.forEach((K,V)->{
                List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = V.stream().map(x -> (OrderMemberReceivedStatistics) x).collect(Collectors.toList());
                Integer totalQuantity = orderMemberReceivedStatisticsList.stream().map(x -> x.getTotalDiamondQuantity()).reduce(0, (x, y) -> x+y);
                OrderMemberReceivedStatistics orderMemberReceivedStatistics = orderMemberReceivedStatisticsList.get(0);
                OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderMemberReceivedStatistics,null,totalQuantity);
                orderReceivedStatisticsVos.add(receivedStatisticsVo);
            });
            resultMap.put(getSign(),orderReceivedStatisticsVos);
            return resultMap;
        }
    };
    private String sign;
    private String desc;

    OrderMemberReceivedStatisticsSignEnum(String sign, String desc) {
        this.sign = sign;
        this.desc = desc;
    }
    /**
     * 统计项
     * @param orderMap
     * @return
     */
    abstract Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object,List<OrderReceivedStatisticsBase>> orderMap);

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }


}
