package com.xxfc.platform.order.rest.background;

import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.OrderUtil;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.xxfc.platform.order.biz.OrderRentVehicleBiz;
import com.xxfc.platform.order.biz.ShuntApplyBiz;
import com.xxfc.platform.order.biz.inner.OrderCalculateBiz;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.ShuntApply;
import com.xxfc.platform.order.pojo.order.RentVehicleBO;
import com.xxfc.platform.order.pojo.order.add.BgAddRentDTO;
import com.xxfc.platform.order.service.OrderRentVehicleService;
import com.xxfc.platform.vehicle.constant.VehicleBookRecordStatus;
import com.xxfc.platform.vehicle.entity.VehicleModel;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import static com.xxfc.platform.order.entity.ShuntApply.STATUS_CONFIRM;
import static com.xxfc.platform.order.entity.ShuntApply.STATUS_CRT;

@RestController
@RequestMapping("/background/shuntApply")
public class BgShuntApplyController extends BaseController<ShuntApplyBiz, ShuntApply> {


    @Autowired
    VehicleFeign vehicleFeign;

    @Autowired
    UserFeign userFeign;

    @Autowired
    OrderRentVehicleBiz orderRentVehicleBiz;

    @Autowired
    OrderCalculateBiz orderCalculateBiz;

    @Autowired
    OrderRentVehicleService orderRentVehicleService;

    @RequestMapping(value = "/confirmApply", method = RequestMethod.POST)
    @ResponseBody
    @ApiOperation(value = "后台确认申请")
    public ObjectRestResponse confirmApply(@RequestBody confirmApplyDTO dto) {

        //查询列表数据
        if (StrUtil.isBlank(getCurrentUserId())) {
            throw new BaseException(ResultCode.AJAX_WECHAT_NOTEXIST_CODE);
        }

        if(null == dto.getApplyId()) {
            throw new BaseException(ResultCode.PARAM_ILLEGAL_CODE);
        }

        ShuntApply shuntApply = baseBiz.selectById(dto.getApplyId());
        if(null == shuntApply && shuntApply.getStatus() != STATUS_CRT) {
            throw new BaseException(ResultCode.PARAM_ILLEGAL_CODE);
        }

        RentVehicleBO detail = new RentVehicleBO();
        detail.setStartTime(shuntApply.getStartTime());
        detail.setEndTime(shuntApply.getEndTime());
        detail.setVehicleId(shuntApply.getVehicleId());
        detail.setModelId(shuntApply.getModelId());
        detail.setStartAddr(shuntApply.getStartCompanyName());
        detail.setStartCompanyId(shuntApply.getStartCompanyId());
        detail.setEndCompanyId(shuntApply.getEndCompanyId());
        detail.setOrder(new BaseOrder(){{setNo(OrderUtil.GetOrderNumber("", OrderUtil.APP_MID));}});

        //预约车辆
        orderRentVehicleService.acquireVehicle(detail, null , VehicleBookRecordStatus.APPROVE.getCode());

        shuntApply.setVehicleId(dto.getVehicleId());
        shuntApply.setStatus(STATUS_CONFIRM);
        shuntApply.setOrderNo(detail.getOrder().getNo());
        baseBiz.updateSelectiveById(shuntApply);

        return ObjectRestResponse.succ();
    }

    @Data
    public static class confirmApplyDTO {
        Integer applyId;
        String vehicleId;
    }
}