package com.xxfc.platform.order.rest;

import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.xxfc.platform.order.biz.OrderRentVehicleBiz;
import com.xxfc.platform.order.biz.ShuntApplyBiz;
import com.xxfc.platform.order.biz.inner.OrderCalculateBiz;
import com.xxfc.platform.order.entity.ShuntApply;
import com.xxfc.platform.order.pojo.order.RentVehicleBO;
import com.xxfc.platform.order.pojo.order.add.AddRentVehicleDTO;
import com.xxfc.platform.order.pojo.order.add.BgAddRentDTO;
import com.xxfc.platform.order.service.OrderRentVehicleService;
import com.xxfc.platform.vehicle.entity.VehicleModel;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import static com.github.wxiaoqi.security.common.vo.PageDataVO.pageInfo;
import static com.xxfc.platform.order.entity.ShuntApply.STATUS_CNL;
import static com.xxfc.platform.order.entity.ShuntApply.STATUS_CRT;

@RestController
@RequestMapping("shuntApply")
public class ShuntApplyController extends BaseController<ShuntApplyBiz, ShuntApply> {


    @Autowired
    VehicleFeign vehicleFeign;

    @Autowired
    UserFeign userFeign;

    @Autowired
    OrderRentVehicleBiz orderRentVehicleBiz;

    @Autowired
    OrderCalculateBiz orderCalculateBiz;

    @Autowired
    OrderRentVehicleService orderRentVehicleService;

    @RequestMapping(value = "/addApply", method = RequestMethod.POST)
    @ResponseBody
    @ApiOperation(value = "申请列表")
    public ObjectRestResponse addApply(@RequestBody ShuntApply shuntApply) {

        //查询列表数据
        if (StrUtil.isBlank(getCurrentUserId())) {
            throw new BaseException(ResultCode.AJAX_WECHAT_NOTEXIST_CODE);
        }
        shuntApply.setUserId(getCurrentUserIdInt());
        shuntApply.setStatus(STATUS_CRT);
        return add(shuntApply);
    }

    @RequestMapping(value = "/cancelApply", method = RequestMethod.POST)
    @ResponseBody
    @ApiOperation(value = "取消申请")
    public ObjectRestResponse addApply(@RequestBody CnlApplyDTO dto) {

        //查询列表数据
        if (StrUtil.isBlank(getCurrentUserId())) {
            throw new BaseException(ResultCode.AJAX_WECHAT_NOTEXIST_CODE);
        }

        ShuntApply shuntApply = baseBiz.selectById(dto.getApplyId());
        if(null == shuntApply) {
            throw new BaseException(ResultCode.PARAM_ILLEGAL_CODE);
        }

        baseBiz.updateSelectiveById(new ShuntApply(){{
            setId(shuntApply.getId());
            setStatus(STATUS_CNL);
        }});
        return ObjectRestResponse.succ();
    }

    @RequestMapping(value = "/pageList", method = RequestMethod.GET)
    @ResponseBody
    @ApiOperation(value = "申请列表")
    public ObjectRestResponse<PageDataVO<ShuntApplyVO>> pageList(QueryDTO dto) {
        //查询列表数据
        if (StrUtil.isBlank(getCurrentUserId())) {
            throw new BaseException(ResultCode.AJAX_WECHAT_NOTEXIST_CODE);
        }
        dto.setUserId(Integer.valueOf(BaseContextHandler.getUserID()));
        Query query = new Query(dto);
        PageDataVO<ShuntApplyVO> pages = PageDataVO.pageInfo(query, () -> baseBiz.selectByWeekend(w -> {
            w.andEqualTo(ShuntApply::getUserId, dto.getUserId());
            return w;
        }, " crt_time desc "), ShuntApplyVO.class);
        pages.getData().forEach(data -> {
            data.setVehicleModel(vehicleFeign.get(data.getModelId()).getData());
        });

        return ObjectRestResponse.succ(pages);
    }

    @RequestMapping(value = "/applyOrder", method = RequestMethod.POST)
    @ResponseBody
    @ApiOperation(value = "申请调车下单")
    public ObjectRestResponse applyOrder(@RequestBody ApplyOrderDTO dto) {

        //查询列表数据
        if (StrUtil.isBlank(getCurrentUserId())) {
            throw new BaseException(ResultCode.AJAX_WECHAT_NOTEXIST_CODE);
        }

        if(null == dto.getApplyId()) {
            throw new BaseException(ResultCode.PARAM_ILLEGAL_CODE);
        }

        ShuntApply shuntApply = baseBiz.selectById(dto.getApplyId());
        if(null == shuntApply) {
            throw new BaseException(ResultCode.PARAM_ILLEGAL_CODE);
        }

//        BgAddRentDTO bgAddRentDTO = new BgAddRentDTO();
//        bgAddRentDTO.setAppUserId(shuntApply.getUserId());
//        bgAddRentDTO.setStartTime(shuntApply.getStartTime());
//        bgAddRentDTO.setEndTime(shuntApply.getEndTime());
//        bgAddRentDTO.setVehicleId(shuntApply.getVehicleId());
//
//        RentVehicleBO bo = orderRentVehicleBiz.initRentVehicleBO(bgAddRentDTO);
//        bo.setDayNum(orderCalculateBiz.getIncludeDays(bgAddRentDTO.getStartTime(), bgAddRentDTO.getEndTime()));
//
//        bo.setAppUserDTO(userFeign.userDetailById(bgAddRentDTO.getAppUserId()).getData());
//        bo.setCrtUser("-1"+ BaseContextHandler.getUserID());
//        //设置-1表示查询所有的车
//        //bo.setUseType(-1);
//        orderRentVehicleService.createOrder(bo);

//        AddRentVehicleDTO vo = new AddRentVehicleDTO(){{
//            setStartTime(shuntApply.getStartTime());
//            setEndTime(shuntApply.getEndTime());
//            setC
//            setDayNum(orderCalculateBiz.getIncludeDays(shuntApply.getStartTime(), shuntApply.getEndTime()));
//        }};

        RentVehicleBO bo = orderRentVehicleBiz.initRentVehicleBO(dto);
        bo.setAppUserDTO(userFeign.userDetailByToken(BaseContextHandler.getToken()).getData());
        orderRentVehicleService.applyCreateOrder(bo, shuntApply.getOrderNo());
        return ObjectRestResponse.succ(bo.getOrder());
    }

    @Data
    public static class QueryDTO extends PageParam {
        Integer userId;
    }

    @Data
    public static class ShuntApplyVO extends ShuntApply {
        VehicleModel vehicleModel;
    }

    @Data
    public static class ApplyOrderDTO extends AddRentVehicleDTO {
        Integer applyId;
    }

    @Data
    public static class CnlApplyDTO {
        Integer applyId;
    }
}