package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.CompanyInfoApplyBiz;
import com.github.wxiaoqi.security.admin.biz.CompanyInfoBiz;
import com.github.wxiaoqi.security.admin.dto.CompanyApplyFindDTO;
import com.github.wxiaoqi.security.admin.entity.CompanyInfo;
import com.github.wxiaoqi.security.admin.entity.CompanyInfoApply;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.admin.dto.CompanyInfoFindDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("backstage/company")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Api(tags = {"商家申请"})
public class AdminCompanyInfoController extends BaseController<CompanyInfoApplyBiz,CompanyInfoApply>implements UserRestInterface {


    @Autowired
    CompanyInfoBiz companyInfoBiz;


    @Autowired
    UserFeign userFeign;


    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }


    @GetMapping("apply/selectList")
    @ApiModelProperty("商家入驻申请")
    public  ObjectRestResponse applySelectList(CompanyApplyFindDTO companyApplyFindDTO) {
     return  baseBiz.selectList(companyApplyFindDTO);
    }


    @GetMapping("apply/info/{id}")
    @ApiModelProperty("商家入驻信息")
    public  ObjectRestResponse applyInfo(@PathVariable("id") Long id ) {
        return ObjectRestResponse.succ( baseBiz.getApplyInfo(id));
    }


    @PostMapping("audit")
    @ApiModelProperty("商家入驻审核")
    public  ObjectRestResponse audit(@RequestBody CompanyInfoApply companyInfoApply) {
        baseBiz.audit(companyInfoApply);
        return ObjectRestResponse.succ();
    }


    @PostMapping("apply")
    @ApiModelProperty("商家入驻申请")
    public  ObjectRestResponse apply(@RequestBody CompanyInfo companyInfo) {
        return ObjectRestResponse.succ(baseBiz.saveApply(companyInfo));
    }


    @PostMapping("upd")
    @ApiModelProperty("商家信息修改")
    public  ObjectRestResponse upd(@RequestBody CompanyInfo companyInfo) {
        companyInfoBiz.saveOrUpd(companyInfo);
        return ObjectRestResponse.succ();
    }


    @GetMapping("info")
    @ApiModelProperty("商家信息")
    public  ObjectRestResponse info() {
        CompanyInfoFindDTO companyInfoFindDTO=new CompanyInfoFindDTO();
        setPowerData(companyInfoFindDTO);
        List<CompanyInfo> list = companyInfoBiz.getList(companyInfoFindDTO);
        if (list == null || list.size() == 0){
            throw  new BaseException("商家不存在", ResultCode.FAILED_CODE);
        }
        return ObjectRestResponse.succ(baseBiz.getCompanyInfo(list.get(0)));
    }


    @GetMapping("selectList")
    @ApiModelProperty("商家列表")
    public  ObjectRestResponse selectList(CompanyInfoFindDTO companyInfoFindDTO) {
        return ObjectRestResponse.succ( companyInfoBiz.selectList(companyInfoFindDTO));
    }


}
