package com.github.wxiaoqi.security.admin.rest;


import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
public class BaseController<Biz extends BaseBiz> extends CommonBaseController {
    
    @Autowired
    protected Biz baseBiz;

    @Autowired
    protected UserAuthConfig userAuthConfig;

    @Autowired
    private UserAuthUtil userAuthUtil;


  public String getUserName()throws Exception{ return  userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getUniqueName(); }

    public Biz getBaseBiz() {
        return baseBiz;
    }

    public String getUserId()throws Exception{ return  userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getId(); }

}
