package com.github.wxiaoqi.security.admin.biz;



import com.github.wxiaoqi.security.admin.entity.CompanyInfoOrder;
import com.github.wxiaoqi.security.admin.mapper.CompanyInfoOrderMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.util.OrderUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;


@Service
@Slf4j
public class CompanyInfoOrderBiz extends BaseBiz<CompanyInfoOrderMapper, CompanyInfoOrder>{



    public  void  saveOrder(CompanyInfoOrder companyInfoOrder){
        companyInfoOrder.setOderNo(OrderUtil.GetOrderNumber("", OrderUtil.COMPANY_MID));
        if (companyInfoOrder.getRealAmount().compareTo(BigDecimal.ZERO) == 0){
            companyInfoOrder.setPayStatus(1);
            companyInfoOrder.setPayTime(System.currentTimeMillis());
        }
        insertSelective(companyInfoOrder);
    }


    public List<CompanyInfoOrder>  getList(Long branchApplyId){
        CompanyInfoOrder companyInfoOrder=new CompanyInfoOrder();
        companyInfoOrder.setBranchApplyId(branchApplyId);
        return  selectList(companyInfoOrder);
    }






}
