package com.github.wxiaoqi.security.admin.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;

@Data
@Table(name = "company_info_order")
public class CompanyInfoOrder {
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键id")
    private Long id;


    @ApiModelProperty("商家申请id")
    @Column(name = "branch_apply_id")
    private Long branchApplyId;


    @ApiModelProperty("订单号")
    @Column(name = "oder_no")
    private String oderNo;


    @ApiModelProperty("实付金额")
    @Column(name = "real_amount")
    private BigDecimal realAmount;



    @ApiModelProperty("支付状态：0-未支付：1-已支付：2-已退款")
    @Column(name = "pay_status")
    private Integer payStatus;



    @ApiModelProperty("订单类别：1-质保金；2-服务费")
    @Column(name = "order_type")
    private Integer orderType;


    @ApiModelProperty("支付时间")
    @Column(name = "pay_time")
    private Long payTime;



    @Column(name = "crt_time")
    private Long crtTime;


    @ApiModelProperty("退款时间")
    @Column(name = "refund_time")
    private Long refundTime;

}