package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleCountRecordBiz;
import com.xxfc.platform.vehicle.entity.VehicleCountRecord;
import com.xxfc.platform.vehicle.pojo.ExcelParamDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

@RestController
@RequestMapping(value = "/vehicleCount")
public class VehicleCountRecordController {

    @Autowired
    VehicleCountRecordBiz vehicleCountRecordBiz;

    @GetMapping("/app/unauth/test")
    public ObjectRestResponse add() {
        vehicleCountRecordBiz.add();
        return ObjectRestResponse.succ();
    }

    @GetMapping("/app/unauth/get")
    public ObjectRestResponse getByTypeAndDate(VehicleCountRecord vehicleCountRecord) {
        return vehicleCountRecordBiz.countDepartureVehicle(vehicleCountRecord);
    }

    @PostMapping("/app/unauth/export")
    public ObjectRestResponse export(@RequestBody ExcelParamDto excelParamDto) {
        return vehicleCountRecordBiz.export(excelParamDto);
    }

    @PostMapping("/app/unauth/download")
    public ObjectRestResponse download(@RequestBody String path, HttpServletResponse response) {
        vehicleCountRecordBiz.download(path, response);
        return ObjectRestResponse.succ();
    }
}
