package com.xxfc.platform.vehicle.feign;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.GoodDataVO;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.entity.*;
import com.xxfc.platform.vehicle.pojo.*;
import com.xxfc.platform.vehicle.pojo.dto.BranchCompanyFindDTO;
import com.xxfc.platform.vehicle.pojo.vo.AccompanyingItemVo;
import com.xxfc.platform.vehicle.pojo.vo.BranComanyLeaderVo;
import com.xxfc.platform.vehicle.pojo.vo.BranchCompanyListVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by ace on 2017/9/15.
 */
@FeignClient(name = "vehicle",contextId = "vh")
public interface VehicleFeign {
    @GetMapping(value = "/vehicleModel/{id}")
    public ObjectRestResponse<VehicleModel> get(@PathVariable(value = "id") int id);

    @GetMapping(value = "/vehicleInfo/{id}")
    public ObjectRestResponse<Vehicle> get(@PathVariable(value = "id") String id);

    @RequestMapping(value = "/vehicleInfo/findById", method = RequestMethod.GET)
    public RestResponse<Vehicle> findById(@RequestParam(value = "id")String id);

    @RequestMapping(value = "/vehicleInfo/getByIds", method = RequestMethod.GET)
    public RestResponse< List<Vehicle>> getByIds(@RequestParam(value = "ids") List<String> id);

    //提车
    @PostMapping("/active/small/departure")
    public RestResponse departureBySmall(@RequestBody VehicleDepartureVo departureVo);

    //还车
    @PostMapping("/active/small/arrival")
    public RestResponse arrivalBySmall(@RequestBody VehicleArrivalVo arrivalVo);

    @GetMapping(value = "/vehicleModel/app/unauth/findRandomVehicle")
    public ObjectRestResponse findRandomVehicle(@RequestParam(value="number")Integer number);

    //修改评分
    @RequestMapping(value = "/vehicleModel/app/addScore", method = RequestMethod.GET)
    public RestResponse addScore(@RequestParam(value="id")Integer  id, @RequestParam(value="score")Integer  score);

    @RequestMapping(value = "/vehicleInfo/rent/book/vehicle", method = RequestMethod.POST)
    public ObjectRestResponse<VehicleBookRecord> rentApplyVehicle(@RequestBody RentVehicleBookDTO rentVehicleBookDTO);

    @RequestMapping(value ="/branchCompany/app/unauth/detail/{id}",method = RequestMethod.GET)
    public ObjectRestResponse<CompanyDetail> getCompanyDetail(@PathVariable(value = "id") Integer id);

    //租车拒绝预约
    @RequestMapping(value = "/vehicleInfo/rent/book/reject/{bookRecordId}", method = RequestMethod.PUT)
    public RestResponse<Integer> rentRejectVehicleBooking(@PathVariable(value = "bookRecordId") Long bookRecordId);

    //取消预约
    @RequestMapping(value = "/vehicleInfo/rent/unbook/{bookRecordId}", method = RequestMethod.DELETE)
    public RestResponse<Integer> rentUnbookVehicle(@PathVariable(value = "bookRecordId") Long bookRecordId);

    //通过预约
    @RequestMapping(value = "/vehicleInfo/rent/book/prove/{bookRecordId}", method = RequestMethod.PUT)
    public RestResponse<Integer> rentProveVehicleBooking(@PathVariable(value = "bookRecordId") Long bookRecordId);

    //获取分公司列表
    @GetMapping("/branchCompany/all")
    public  List<BranchCompany>  companyAll(
            @RequestParam(value = "dataAll")Integer dataAll,
            @RequestParam(value = "dataCompany")String dataCompany,
            @RequestParam(value = "dataZone")String dataZone);

    @GetMapping("/branchCompany/entityList")
    public ObjectRestResponse<List<BranchCompany>> branchCompanyEntityList(@RequestParam("entity") Map<String, Object> entity);

    @RequestMapping(value = "/user/license/one", method = RequestMethod.GET)
    public RestResponse<VehicleUserLicense> one(@RequestParam(value="id",defaultValue="0")Integer  id) throws Exception;

    @RequestMapping(value = "/user/license/company/getOne", method = RequestMethod.GET)
    public RestResponse<VehicleUserLicense> getOne(
            @RequestParam(value="id",defaultValue="0")Integer  id) throws Exception ;

    @RequestMapping(value = "/user/license/multi", method = RequestMethod.GET)
    public ObjectRestResponse<List<VehicleUserLicense>> multi(@RequestBody QueryMultiDTO dto) throws Exception;

    @GetMapping("/user/license/getVehicleLicenseList")
    public ObjectRestResponse<List<VehicleUserLicense>> getVehicleLicenseList(@RequestParam(value="ids") String ids);

    /**
     * 获取优质车型接口
     * @param page
     * @param limit
     * @return 返回
     */
    @GetMapping("/vehicleModel/goodList")
    ObjectRestResponse<List<GoodDataVO>> goodList(@RequestParam(value = "page") Integer page, @RequestParam("limit") Integer limit);

    /**
     * 根据一个id获取城市
     * @param id
     * @return
     */
    @GetMapping("/sysRegion/getSysRegionById/{id}")
   RestResponse getSysRegionById(@PathVariable(value = "id") Integer id);
    /**
     * 多个城市code获取城市代码
     * @param idSet
     * @return
     */
    @PostMapping("/sysRegion/getSysRegion")
    ObjectRestResponse<List<SysRegion>> getSysRegion(@RequestBody Set<Integer> idSet);

    /**
     * 获取公司所在的城市
     * @param zoneList
     * @param companyList
     * @return
     */
    @GetMapping("/city/corporationCity")
    ObjectRestResponse<Set<Integer>> corporationCity( @RequestParam(value = "zoneList") String zoneList,
                                                       @RequestParam(value = "companyList") String companyList);


    @GetMapping("/accompanyingItem/app/unauth/items")
    public RestResponse<List<AccompanyingItemVo>> listAccompanyingItem();

    @GetMapping("/branchCompany/findByAreaId")
    List<Integer> findCompanyIdsByAreaId(@RequestParam(value = "areaId") Integer areaId);

    @GetMapping("/branchCompany/company")
    Map<Integer, BranComanyLeaderVo> findCompanyLeaderMapByIds(@RequestParam(value = "companyIds") List<Integer> companyIds);

    @GetMapping("/vehicleModel/app/unauth/detail-param")
    ObjectRestResponse<VModelDetailVO> detailByParam(@RequestParam("vehicleModel") Map<String, Object> vehicleModel);

    @PostMapping("/vehicleModel/app/unauth/findVehicleModelPage")
    public ObjectRestResponse<PageDataVO<VehicleModelVo>> findVehicleModelPageUnauthfind(@RequestBody VehicleModelQueryCondition vmqc);


    //cata
    /**
     * 查询当前车型拥有的标签
     * @param ids
     * @return
     */
    @GetMapping("/cata/add/getCatasByIds/{ids}")
    public ObjectRestResponse<List<VehiclePlatCata>> getCatasByIds(@PathVariable("ids") String ids);

    @GetMapping("/vehicleInfo/findwith_plate_number")
    List<String> findbyPlateNumber(@RequestParam(value = "plateNumber") String plateNumber);

    /**
     * 根据位置查询
     * @param branchCompanyFindDTO
     * @return
     */
    @PostMapping("/branchCompany/app/unauth/companys")
    PageDataVO<BranchCompanyListVO> findBranchCompanyWithPage(@RequestBody BranchCompanyFindDTO branchCompanyFindDTO);

    @GetMapping("/vehicleInfo/findVehicleIds")
    List<String> findbyPlateNumberAndVehicleCod(@RequestParam(value = "plateNumber") String plateNumber,@RequestParam(value = "vehicleCode") String vehicleCode);
}
