package com.xxfc.platform.summit.biz;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.summit.entity.Activity;
import com.xxfc.platform.summit.mapper.ActivityMapper;
import com.xxfc.platform.summit.pojo.AccessType;
import com.xxfc.platform.summit.pojo.ActivityQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * @author Administrator
 */
@Service
public class ActivityBiz extends BaseBiz<ActivityMapper, Activity> {

    /**
     * 未删除
     */
    private Integer NOT_DELETE = 0;
    private Activity activity;
    /**
     * 已发布
     */
    private Integer PUBLISHED = 1;

    public Object getList(ActivityQuery query) {

        Example exa = new Example(Activity.class);
        Example.Criteria criteria = exa.createCriteria();
        criteria.andEqualTo("isDel", NOT_DELETE);
        if (StringUtils.isNotBlank(query.getTitle())) {
            criteria.andLike("title", String.format("%%%s%%", query.getTitle().trim()));
        }
        if (query.getStartTime() != null) {
            criteria.andLike("startTime", query.getStartTime()/(1000*60*60)+"%");
        }
        if (query.getStatus() != null) {
            criteria.andEqualTo("status", query.getStatus());
        }

        if (query.getType() != null && AccessType.PUBLIC.getCode().equals(query.getType())) {
            criteria.andEqualTo("isPublish", PUBLISHED);
        }
        exa.orderBy("rank").asc().orderBy("startTime").desc();

//        if (AccessType.PUBLIC.getCode().equals(query.getType())) {
////            return mapper.selectByExample(exa);
////        }


        PageHelper.startPage(query.getPage(), query.getLimit());
        List<Activity> activities = mapper.selectByExample(exa);
        return new PageInfo<Activity>(activities);

    }

    @Transactional(rollbackFor = Exception.class)
    public Boolean update(Activity activity) {
        try {
            activity.setUpdTime(System.currentTimeMillis());
            mapper.updateByPrimaryKeySelective(activity);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }

    }

    @Transactional(rollbackFor = Exception.class)
    public boolean add(Activity activity) {
        try {
            activity.setCrtTime(System.currentTimeMillis());
            activity.setIsDel(0);
            if (activity.getIsOpenBm() == null) {
                activity.setIsOpenBm(0);
            }
            if (activity.getIsPublish() == null) {
                activity.setIsPublish(0);
            }
            if (activity.getIsShow() == null) {
                activity.setIsShow(0);
            }
            mapper.insertSelective(activity);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
    }

    @Override
    public void updateSelectiveById(Activity activity) {
        activity.setUpdTime(System.currentTimeMillis());
        mapper.updateByPrimaryKeySelective(activity);
    }
}
