package com.xxfc.platform.vehicle.rest.admin;

import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleModelCalendarPriceBiz;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelCalendarPriceSaveDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleModelDayPriceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/10/14 17:35
 */
@RestController
@RequestMapping("/admin/vehicle_model/calendar_price")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@Api(tags = "车型日历价格")
public class VehicleModelCalendarPriceAdminController {
    private final VehicleModelCalendarPriceBiz vehicleModelCalendarPriceBiz;

    @ApiOperation("车型日历价格设置")
    @PostMapping(value = {"/add_edit/{date}","/add_edit"})
    public ObjectRestResponse<Void> add(@RequestBody(required = false) List<VehicleModelCalendarPriceSaveDTO> vehicleModelCalendarPriceSaveDTO,
                                        @PathVariable(name = "date",required = false) String date ,UserDTO userDTO){
        vehicleModelCalendarPriceBiz.addVehicleModelCalendarPrice(vehicleModelCalendarPriceSaveDTO,date,userDTO.getId());
        return ObjectRestResponse.succ();
    }

    @ApiOperation("车型日历价格")
    @GetMapping("/day")
    public ObjectRestResponse<VehicleModelDayPriceVo> listVehicleModelCalendarPriceWithMonth(@RequestParam(value = "date") String dateStr){
        Date date = Date.from(LocalDate.parse(dateStr).atStartOfDay(ZoneId.systemDefault()).toInstant());
        List<VehicleModelDayPriceVo> vehicleModelDayPriceVos = vehicleModelCalendarPriceBiz.findVehicleModelcalendarPriceByDateWithDay(date);
        return ObjectRestResponse.succ(vehicleModelDayPriceVos);
    }

    @ApiOperation("根据月份查询的设置")
    @GetMapping("/month")
    public ObjectRestResponse<List<VehicleModelCalendarPriceSaveDTO>> listVehicleModelCalendarPriceWithDay(@RequestParam(value = "date") String dateStr){
        Date date = Date.from(LocalDate.parse(dateStr).atStartOfDay(ZoneId.systemDefault()).toInstant());
        List<VehicleModelCalendarPriceSaveDTO> calendarPrices = vehicleModelCalendarPriceBiz.findVehicleModelCalendarPricesByDateWithMonth(date);
        return ObjectRestResponse.succ(calendarPrices);
    }

    @ApiOperation("查询所有车型的的基本信息(id,价格)")
    @GetMapping("/vehicle_model/all")
    public ObjectRestResponse<VehicleModelDayPriceVo> listVehicleModelPrice(){
        List<VehicleModelDayPriceVo> vehicleModelDayPriceVos = vehicleModelCalendarPriceBiz.listVehicleModelPrice();
        return ObjectRestResponse.succ(vehicleModelDayPriceVos);
    }
}
