package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleApplyBiz;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.pojo.dto.VehicleApplyFindDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/vehicle")
@Api(tags = {"商家入驻"})
public class AppVehicleApplyController extends BaseController<VehicleApplyBiz> {





    @PostMapping("apply")
    @ApiModelProperty("商家入驻申请")
    public  ObjectRestResponse apply(@RequestBody Vehicle vehicle) {
     if (vehicle.getSubordinateBranch() == null || vehicle.getSubordinateBranch() == 0){
         List<Integer> companyIds = getBusinessUserCompanyIds();
         if (companyIds != null && companyIds.size() > 0){
             vehicle.setSubordinateBranch(companyIds.get(0));
         }
     }
     return ObjectRestResponse.succ(baseBiz.saveApply(vehicle));
    }



    @GetMapping("apply/selectList")
    @ApiModelProperty("商品审核列表")
    public  ObjectRestResponse selectList(VehicleApplyFindDTO vehicleApplyFindDTO) {
        List<Integer> companyIds = getBusinessUserCompanyIds();
        if (companyIds == null && companyIds.size() == 0){
            return  ObjectRestResponse.succ();
        }
        vehicleApplyFindDTO.setDataCompanyIds(companyIds);
        return  baseBiz.selectListByApp(vehicleApplyFindDTO);
    }












}
