package com.xxfc.platform.vehicle.biz;



import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.entity.VehicleApply;
import com.xxfc.platform.vehicle.entity.VehicleExtension;
import com.xxfc.platform.vehicle.entity.VehiclePlatCata;;
import com.xxfc.platform.vehicle.mapper.VehicleEextensionMapper;
import com.xxfc.platform.vehicle.pojo.dto.VehicleExtensionFindDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleExtensionVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;


@Service
@Slf4j
public class VehicleExtensionBiz extends BaseBiz<VehicleEextensionMapper, VehicleExtension>{

    @Autowired
    VehiclePlatCataBiz vehiclePlatCataBiz;

    @Autowired
    VehicleBiz vehicleBiz;

    @Autowired
    VehicleApplyBiz vehicleApplyBiz;




    @Transactional(rollbackFor = Exception.class)
    public  void   saveOrUpd(String  vehicleId,String extensionList){
        if (StringUtils.isBlank(vehicleId) || StringUtils.isBlank(extensionList)){
             throw  new BaseException("参数不能为空",ResultCode.FAILED_CODE);
        }
        List<Integer> list = Arrays.asList(extensionList.split(",")).parallelStream().map(s -> Integer.valueOf(s)).collect(Collectors.toList());
        List<Integer> ids=new ArrayList<>();
        if (list.size() > 0L){
            for (Integer extensionId:list){
                VehiclePlatCata vehiclePlatCata = vehiclePlatCataBiz.selectById(extensionId);
                if (vehiclePlatCata == null ){
                     continue;
                }
                VehicleExtension vehicleExtension=new VehicleExtension();
                vehicleExtension.setCataId(extensionId);
                vehicleExtension.setVehicleId(vehicleId);
                vehicleExtension.setIsDel(0);
                VehicleExtension vehicleExtension1=selectOne(vehicleExtension);
                Integer id;
                if (vehicleExtension1 == null){
                    vehicleExtension.setParentCataId(vehiclePlatCata.getParentId());
                    insertSelective(vehicleExtension);
                    id=vehicleExtension.getId();
                }else {
                    id=vehicleExtension1.getId();
                }
                ids.add(id);
            }
        }
        mapper.delByIds(ids,vehicleId);
    }


    public List<VehicleExtensionVO>  selectList(String vehicleId,Integer parentCataId){
        return mapper.selectList(vehicleId,parentCataId);
    }

    public List<VehicleExtensionVO>  selectListByApply(List<Integer> cataIds,Integer parentCataId){
        return  mapper.selectListByApply(cataIds,parentCataId);
    }


    public List<VehicleExtensionVO>  getTree(String vehicleId){
        List<VehicleExtensionVO> vehicleExtensionVOS = mapper.selectListByParent(vehicleId);
        if (vehicleExtensionVOS.size() > 0){
            for (VehicleExtensionVO extensionVO:vehicleExtensionVOS) {
                extensionVO.setChildren(selectList(vehicleId,extensionVO.getParentCataId()));
            }
        }
        return  vehicleExtensionVOS;

    }


    public List<VehicleExtensionVO>  getTreeByApply(List<Integer> cataIds){
        List<VehicleExtensionVO> vehicleExtensionVOS = mapper.selectListByApplyParent(cataIds);
        if (vehicleExtensionVOS.size() > 0){
            for (VehicleExtensionVO extensionVO:vehicleExtensionVOS) {
                extensionVO.setChildren(selectListByApply(cataIds,extensionVO.getParentCataId()));
            }
        }
        return  vehicleExtensionVOS;

    }



    public List<VehicleExtensionVO>  getTreeByPlatCata(VehicleExtensionFindDTO extensionFindDTO){
        if (StringUtils.isBlank(extensionFindDTO.getVehicleId()) && extensionFindDTO.getVehicleApplyId() == null){
            throw  new BaseException("参数不能为空",ResultCode.FAILED_CODE);
        }
        if (StringUtils.isNotBlank(extensionFindDTO.getVehicleId())){
            Vehicle vehicle = vehicleBiz.selectById(extensionFindDTO.getVehicleId());
            extensionFindDTO.setGoodsType(vehicle.getGoodsType());
        }else {
            VehicleApply vehicleApply = vehicleApplyBiz.selectById(extensionFindDTO.getVehicleApplyId());
            extensionFindDTO.setGoodsType(vehicleApply.getGoodsType());
            if (StringUtils.isNotBlank(vehicleApply.getExtensionList())){
                extensionFindDTO.setCataIds(Arrays.asList(vehicleApply.getExtensionList().split(",")).parallelStream().map(s -> Integer.valueOf(s)).collect(Collectors.toList()));
            }
        }
        extensionFindDTO.setParentId(0);
        List<VehicleExtensionVO> vehicleExtensionVOS = mapper.selectListByPlatCata(extensionFindDTO);
        if (vehicleExtensionVOS.size() > 0){
            for (VehicleExtensionVO extensionVO:vehicleExtensionVOS) {
                extensionFindDTO.setParentId(extensionVO.getId());
                extensionVO.setChildren(mapper.selectListByPlatCata(extensionFindDTO));
            }
        }
        return  vehicleExtensionVOS;

    }













}
