package com.xxfc.platform.order.mqhandler;

import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.ShuntApply;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

import static com.xxfc.platform.order.config.RabbitDelayConfig.*;

/**
 * rabbitMq生产者类
 * @author zhanghang
 * @date 2018/12/13
 */
@Slf4j
@Component
public class RabbitProduct {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    public void sendDelayMessage(BaseOrder baseOrder, Long delayTime) {
        //这里的消息可以是任意对象，无需额外配置，直接传即可
        log.info("===============延时队列生产消息====================");
        log.info("发送时间:{},发送内容:{}", LocalDateTime.now(), baseOrder.toString());
        this.rabbitTemplate.convertAndSend(
                ORDER_CANCEL_EXC,
                ORDER_CANCEL_KEY,
                baseOrder,
                message -> {
                    //注意这里时间可以使long，而且是设置header
                    message.getMessageProperties().setHeader("x-delay", delayTime);
                    return message;
                }
        );
        log.info("{}ms后执行", delayTime);
    }

    public void sendApplyDelayMessage(ShuntApply shuntApply, Long delayTime) {
        //这里的消息可以是任意对象，无需额外配置，直接传即可
        log.info("===============延时队列生产消息====================");
        log.info("发送时间:{},发送内容:{}", LocalDateTime.now(), shuntApply.toString());
        this.rabbitTemplate.convertAndSend(
                APPLY_CANCEL_EXC,
                APPLY_CANCEL_KEY,
                shuntApply,
                message -> {
                    //注意这里时间可以使long，而且是设置header
                    message.getMessageProperties().setHeader("x-delay", delayTime);
                    return message;
                }
        );
        log.info("{}ms后执行", delayTime);
    }

    public void sendApplyRequireDelayMessage(ShuntApply shuntApply, Long delayTime) {
        //这里的消息可以是任意对象，无需额外配置，直接传即可
        log.info("===============延时队列生产消息====================");
        log.info("发送时间:{},发送内容:{}", LocalDateTime.now(), shuntApply.toString());
        this.rabbitTemplate.convertAndSend(
                APPLY_REQUIRE_CANCEL_EXC,
                APPLY_REQUIRE_CANCEL_KEY,
                shuntApply,
                message -> {
                    //注意这里时间可以使long，而且是设置header
                    message.getMessageProperties().setHeader("x-delay", delayTime);
                    return message;
                }
        );
        log.info("{}ms后执行", delayTime);
    }
}

