package com.xxfc.platform.order.config;

import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * rabbitmq配置类
 * 过期订单取消延时队列
 * @author zhanghang
 * @date 2019/1/7
 */
@Configuration
public class RabbitDelayConfig {

    public static final String ORDER_CANCEL_EXC = "order_cancel_delay_exchange";
    public static final String ORDER_CANCEL_QUE = "order_cancel_delay_queue";
    public static final String ORDER_CANCEL_KEY = "order_cancel_delay_key";
    public static final String APPLY_CANCEL_EXC = "apply_cancel_delay_exchange";
    public static final String APPLY_CANCEL_QUE = "apply_cancel_delay_queue";
    public static final String APPLY_CANCEL_KEY = "apply_cancel_delay_key";
    public static final String APPLY_REQUIRE_CANCEL_EXC = "apply_require_cancel_delay_exchange";
    public static final String APPLY_REQUIRE_CANCEL_QUE = "apply_require_cancel_delay_queue";
    public static final String APPLY_REQUIRE_CANCEL_KEY = "apply_require_cancel_delay_key";


    /**
     * 自动取消订单延时队列交换机
     * 注意这里的交换机类型：CustomExchange 
     * @return
     */
    @Bean(ORDER_CANCEL_EXC)
    public CustomExchange orderDelayExchange(){
        Map<String, Object> args = new HashMap<>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange(ORDER_CANCEL_EXC,"x-delayed-message",true, false, args);
    }

    /**
     * 申请下单自动取消延时队列交换机
     * 注意这里的交换机类型：CustomExchange
     * @return
     */
    @Bean(APPLY_CANCEL_EXC)
    public CustomExchange applyDelayExchange(){
        Map<String, Object> args = new HashMap<>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange(APPLY_CANCEL_EXC,"x-delayed-message",true, false, args);
    }

    /**
     * 申请需求自动取消延时队列交换机
     * 注意这里的交换机类型：CustomExchange
     * @return
     */
    @Bean(APPLY_REQUIRE_CANCEL_EXC)
    public CustomExchange applyRequireDelayExchange(){
        Map<String, Object> args = new HashMap<>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange(APPLY_REQUIRE_CANCEL_QUE,"x-delayed-message",true, false, args);
    }


    /**
     * 自动取消订单延时队列
     * @return
     */
    @Bean(ORDER_CANCEL_QUE)
    public Queue delayQueue(){
        return new Queue(ORDER_CANCEL_QUE,true);
    }

    /**
     * 申请下单自动取消延时队列
     * @return
     */
    @Bean(APPLY_CANCEL_QUE)
    public Queue applyDelayQueue(){
        return new Queue(APPLY_CANCEL_QUE,true);
    }

    /**
     * 申请需求自动取消延时队列
     * @return
     */
    @Bean(APPLY_REQUIRE_CANCEL_QUE)
    public Queue applyRequireDelayQueue(){
        return new Queue(APPLY_REQUIRE_CANCEL_QUE,true);
    }



    /**
     * 自动取消订单给延时队列绑定交换机
     * @return
     */
    @Bean("cfgDelayBinding")
    public Binding cfgDelayBinding(@Qualifier(ORDER_CANCEL_QUE) Queue cfgDelayQueue, @Qualifier(ORDER_CANCEL_EXC) CustomExchange cfgUserDelayExchange){
        return BindingBuilder.bind(cfgDelayQueue).to(cfgUserDelayExchange).with(ORDER_CANCEL_KEY).noargs();
    }

    /**
     * 申请下单自动取消给延时队列绑定交换机
     * @return
     */
    @Bean("acqDelayBinding")
    public Binding acqDelayBinding(@Qualifier(APPLY_CANCEL_QUE) Queue acqDelayQueue, @Qualifier(APPLY_CANCEL_EXC) CustomExchange acqUserDelayExchange){
        return BindingBuilder.bind(acqDelayQueue).to(acqUserDelayExchange).with(APPLY_CANCEL_KEY).noargs();
    }

    /**
     * 申请下单自动取消给延时队列绑定交换机
     * @return
     */
    @Bean("acqRequireDelayBinding")
    public Binding acqRequireDelayBinding(@Qualifier(APPLY_REQUIRE_CANCEL_QUE) Queue acqDelayQueue, @Qualifier(APPLY_REQUIRE_CANCEL_EXC) CustomExchange acqUserDelayExchange){
        return BindingBuilder.bind(acqDelayQueue).to(acqUserDelayExchange).with(APPLY_REQUIRE_CANCEL_KEY).noargs();
    }
}

