package com.xxfc.platform.order.biz;

import cn.hutool.core.collection.CollUtil;
import org.springframework.stereotype.Service;

import com.xxfc.platform.order.entity.SpecialRent;
import com.xxfc.platform.order.mapper.SpecialRentMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.util.List;

/**
 * 特惠租车
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-10-31 11:02:42
 */
@Service
public class SpecialRentBiz extends BaseBiz<SpecialRentMapper, SpecialRent> {

    /**
     * 判断车辆是否有进行中的特惠租车
     * @param vehicleId
     * @return
     */
    public Boolean checkHasSpecialRent(String vehicleId) {
        List<SpecialRent> list = selectByWeekend(w -> {
            w.andIn(SpecialRent::getStatus, CollUtil.newArrayList(SpecialRent.STATUS_CRT, SpecialRent.STATUS_ORDER))
             .andEqualTo(SpecialRent::getVehicleId, vehicleId);
            return w;
        });

        if(list.size() > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}