package com.github.wxiaoqi.security.admin.biz;


import cn.hutool.json.JSONUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.admin.dto.CompanyInfoFindDTO;
import com.github.wxiaoqi.security.admin.dto.UserCommentFindDTO;
import com.github.wxiaoqi.security.admin.entity.*;
import com.github.wxiaoqi.security.admin.mapper.CompanyInfoMapper;
import com.github.wxiaoqi.security.admin.mapper.UserCommentMapper;
import com.github.wxiaoqi.security.admin.vo.UserCommentVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.app.entity.Cofig;
import com.xxfc.platform.app.feign.ConfigFeign;
import com.xxfc.platform.universal.dto.SendMsgDTO;
import com.xxfc.platform.universal.feign.MQSenderFeign;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.Date;
import java.util.List;

import static com.github.wxiaoqi.security.common.config.rabbit.RabbitConstant.ADMIN_TOPIC;
import static com.github.wxiaoqi.security.common.config.rabbit.RabbitConstant.KEY_CORPORATION_UPD;


@Service
@Slf4j
public class UserCommentBiz extends BaseBiz<UserCommentMapper, UserComment>{








    public void addOrUpd(UserComment userComment){
        if (StringUtils.isBlank(userComment.getCommentText())){
            throw  new BaseException("参数不能为空", ResultCode.FAILED_CODE);
        }
        Integer parentId = userComment.getParentId() == null ? 0 : userComment.getParentId();
        Integer rootParentId = userComment.getRootParentId() == null ? 0 : userComment.getRootParentId();
        if (parentId > 0){
            UserComment parentComment = selectById(parentId);
            if (parentComment == null ){
                throw  new BaseException("该评论不存在", ResultCode.FAILED_CODE);
            }
            rootParentId=parentComment.getRootParentId();
            userComment.setSoureId(parentComment.getSoureId());
            userComment.setSoureUserId(parentComment.getSoureUserId());
            userComment.setSoureType(parentComment.getSoureType());
            userComment.setToUserId(parentComment.getUserId());
            userComment.setRootParentId(rootParentId);
        }else {
            if (StringUtils.isBlank(userComment.getSoureId())){
                throw  new BaseException("资源ID不能为空", ResultCode.FAILED_CODE);
            }
        }
        userComment.setCreateTime(new Date());
        insertSelective(userComment);
        Integer id = userComment.getId();
        if (id > 0 ){
            if (rootParentId == 0){
                UserComment userComment1=new UserComment();
                userComment1.setId(id);
                userComment1.setRootParentId(id);
                updateSelectiveById(userComment1);
            }else {
                mapper.addreplyNum(rootParentId);
            }
        }
    }


    public PageDataVO<UserCommentVo> selectList(UserCommentFindDTO userCommentFindDTO){
        PageHelper.startPage(userCommentFindDTO.getPage(), userCommentFindDTO.getLimit());
        PageInfo<UserCommentVo> pageInfo = new PageInfo<>(getList(userCommentFindDTO));
        PageDataVO<UserCommentVo> dataVO = PageDataVO.pageInfo(pageInfo);
        Integer rootParentId = userCommentFindDTO.getRootParentId() == null ? 0 : userCommentFindDTO.getRootParentId();
        if (rootParentId == 0 && dataVO.getData() != null){
            List<UserCommentVo> list = dataVO.getData();
            if (list != null && list.size() > 0){
                for (UserCommentVo commentVo:list){
                    userCommentFindDTO.setParentId(null);
                    userCommentFindDTO.setRootParentId(commentVo.getRootParentId());
                    PageDataVO<UserCommentVo> pageDataVO=selectList(userCommentFindDTO);
                    if (pageDataVO != null ){
                        commentVo.setChilder(pageDataVO);
                    }
                }
            }
        }
        return dataVO;
    }


    public  List<UserCommentVo> getList(UserCommentFindDTO commentFindDTO){
        return  mapper.selectList(commentFindDTO);
    }


    public PageDataVO<UserCommentVo> selectListByToUserId(UserCommentFindDTO userCommentFindDTO){
        PageHelper.startPage(userCommentFindDTO.getPage(), userCommentFindDTO.getLimit());
        PageInfo<UserCommentVo> pageInfo = new PageInfo<>(getListByToUserId(userCommentFindDTO));
        PageDataVO<UserCommentVo> dataVO = PageDataVO.pageInfo(pageInfo);
        return dataVO;
    }



    public  List<UserCommentVo> getListByToUserId(UserCommentFindDTO commentFindDTO){
        return  mapper.selectListByToUserId(commentFindDTO);
    }


    public PageDataVO<UserCommentVo> selectListV2(UserCommentFindDTO userCommentFindDTO){
        PageHelper.startPage(userCommentFindDTO.getPage(), userCommentFindDTO.getLimit());
        PageInfo<UserCommentVo> pageInfo = new PageInfo<>(getList(userCommentFindDTO));
        PageDataVO<UserCommentVo> dataVO = PageDataVO.pageInfo(pageInfo);
        return dataVO;
    }


}
