package com.xxfc.platform.summit.controller;


import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.summit.biz.ActivityBiz;
import com.xxfc.platform.summit.biz.ActivityBmBiz;
import com.xxfc.platform.summit.biz.UserBiz;
import com.xxfc.platform.summit.entity.ActivityBm;
import com.xxfc.platform.summit.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("auth/activity")
@IgnoreClientToken
@IgnoreUserToken
public class AuthActivityController extends BaseController<ActivityBmBiz,ActivityBm> {


    @Autowired
    UserBiz userBiz;

    @Autowired
    private ActivityBmBiz activityBmBiz;


    @PostMapping("app/unauth/bm")
    public ObjectRestResponse bm(@RequestBody ActivityBm activityBm, HttpServletRequest request){
        User user=userBiz.getUserInfo(request,activityBm.getActivityId());
        try {
            return baseBiz.userBmOrQd(activityBm,user.getId());
        }catch (Exception e){
            e.printStackTrace();
            return  ObjectRestResponse.createDefaultFail();
        }

    }

    @PostMapping("app/unauth/qd")
    public ObjectRestResponse qd(@RequestBody ActivityBm activityBm, HttpServletRequest request){
        User user=userBiz.getUserInfo(request,activityBm.getActivityId());
        try {
            return baseBiz.userBmOrQd(activityBm,user.getId());
        }catch (Exception e){
            e.printStackTrace();
            return  ObjectRestResponse.createDefaultFail();
        }

    }

    @GetMapping("app/unauth/subscribe")
    public ObjectRestResponse subscribe(HttpServletRequest request){
        return activityBmBiz.checkSubscribe(request);
    }

    @GetMapping("app/unauth/userInfo")
    public ObjectRestResponse userInfo(Integer pId,HttpServletRequest request){
        return activityBmBiz.getUserInfo(pId,request);
    }


}
