package com.xxfc.platform.order.rest.background;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.biz.CompanyPerformanceBiz;
import com.xxfc.platform.order.pojo.dto.CompanyPerformanceFindDTO;
import com.xxfc.platform.order.bo.CompanyPerformanceBo;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author libin
 * @version 1.0
 * @description 公司业绩查询
 * @data 2019/11/23 14:32
 */
@RestController
@RequestMapping("/statistics")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class CompanyOrderReceivedStatiscsAdminController {

      private final CompanyPerformanceBiz companyPerformanceBiz;

      @PostMapping("/company_performance")
      public ObjectRestResponse<PageDataVO<CompanyPerformanceBo>> companyPerformance(@RequestBody CompanyPerformanceFindDTO companyPerformanceFindDTO){
          PageDataVO<CompanyPerformanceBo> dataVO  = companyPerformanceBiz.selectCompanyPerformancePage(companyPerformanceFindDTO);
          return ObjectRestResponse.succ(dataVO);
      }
}
