package com.xxfc.platform.order.mapper;

import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.pojo.Achievement;
import com.xxfc.platform.order.pojo.QueryCriteria;
import com.xxfc.platform.order.pojo.bg.BgOrderListVo;
import com.xxfc.platform.order.pojo.dto.MemberOrderBo;
import com.xxfc.platform.order.pojo.dto.MemberOrderFindDTO;
import com.xxfc.platform.order.pojo.dto.OrderDTO;
import com.xxfc.platform.order.pojo.order.OrderListVo;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import org.apache.ibatis.annotations.Param;
import tk.mybatis.mapper.common.Mapper;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**;
 * 
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-15 21:30:33
 */
public interface BaseOrderMapper extends Mapper<BaseOrder> {

	public List<OrderPageVO> pageByParm(Map<String, Object> paramMap);

	public List<OrderListVo> listOrder(Map<String, Object> paramMap);

	public List<OrderPageVO> getRentVehicle(Map<String, Object> paramMap);

	public List<OrderPageVO> getTourList(Map<String, Object> paramMap);

	public OrderPageVO getOrderDetail(String no);

	public List<OrderPageVO> selectAllRentVehicleOrder(Map<String, Object> paramMap);

	public List<OrderPageVO> selectAllTourOrder(Map<String, Object> paramMap);

	List<MemberOrderBo> findMemberOrders(MemberOrderFindDTO memberOrderFindDTO);

	public List<BgOrderListVo> getAllOrderList(Map<String, Object> paramMap);

    List<OrderDTO> selectOrdersByTypeAndTime(@Param("types") List<Integer> types,
											 @Param("hasPay") Integer hasPay,
											 @Param("startDate") Date startDate,
											 @Param("endDate") Date endDate);

    List<Achievement> selectTotalStatistical(QueryCriteria queryCriteria);

    List<OrderDTO> selectBaeOrderByOrderIds(@Param("orderIds") List<Integer> orderIds);
}
