package com.xxfc.platform.order.jobhandler;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.xxfc.platform.order.biz.OrderMemberReceivedStatisticsBiz;
import com.xxfc.platform.order.biz.OrderReceivedStatisticsBiz;
import com.xxfc.platform.order.biz.OrderRentVehicleReceivedStatisticsBiz;
import com.xxfc.platform.order.biz.OrderTourReceivedStatisticsBiz;
import com.xxfc.platform.order.entity.OrderMemberReceivedStatistics;
import com.xxfc.platform.order.entity.OrderRentVehicleReceivedStatistics;
import com.xxfc.platform.order.entity.OrderTourReceivedStatistics;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author libin
 * @version 1.0
 * @description 订单统计 定时任务
 * @data 2019/11/11 11:09
 */
@JobHandler(value = "orderReceivedStatisticsJobHandler")
@Component
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class OrderReceivedStatisticsJobHandler extends IJobHandler {

    private final OrderReceivedStatisticsBiz orderReceivedStatisticsBiz;
    private final OrderRentVehicleReceivedStatisticsBiz orderRentVehicleReceivedStatisticsBiz;
    private final OrderTourReceivedStatisticsBiz orderTourReceivedStatisticsBiz;
    private final OrderMemberReceivedStatisticsBiz orderMemberReceivedStatisticsBiz;
    private final VehicleFeign vehicleFeign;

    @Override
    public ReturnT<String> execute(String arg) throws Exception {
        DateTime yesterday = DateUtil.yesterday();
        if (StringUtils.hasText(arg)){
            yesterday =  DateUtil.parse(arg,"yyyy-MM-dd");
        }

        Date startDate = DateUtil.beginOfDay(yesterday).toJdkDate();
        Date endDate = DateUtil.endOfDay(yesterday).toJdkDate();
        Map<Integer, String> companyMap = vehicleFeign.findCompanyMap();

        //旅游订单
        List<OrderTourReceivedStatistics> orderTourReceivedStatisticsList = Collections.EMPTY_LIST;
        //租车订单
        List<OrderRentVehicleReceivedStatistics> orderRentVehicleReceivedStatisticsList = orderRentVehicleReceivedStatisticsBiz.orderRentVehicleReceivedStatistics(startDate, endDate, companyMap);
        //会员订单
        List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = orderMemberReceivedStatisticsBiz.orderMemberReceivedStatistics(startDate, endDate, companyMap);
        //订单
        orderReceivedStatisticsBiz.orderReceivedStatistics(orderMemberReceivedStatisticsList,
                orderTourReceivedStatisticsList,
                orderRentVehicleReceivedStatisticsList,
                startDate);
        return new ReturnT<>(ReturnT.SUCCESS_CODE,"订单统计成功执行");
    }
}
