package com.xxfc.platform.order.pojo.price;

import cn.hutool.core.collection.CollUtil;
import com.xxfc.platform.vehicle.pojo.dto.order.VMCalendarPriceCostDTO;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class DelayAddPriceVO {
    /**
     * 延期增加的天数
     */
    Integer delayAddDays = 0;

    /**
     * 不计免赔单价
     */
    BigDecimal damageSafePrice = BigDecimal.ZERO;

    /**
     * 延期不记免赔费用
     */
    BigDecimal delayDamageSafeAmount = BigDecimal.ZERO;

    /**
     * 使用（消耗）详情列表
     */
    List<VMCalendarPriceCostDTO> delayAmountList = CollUtil.newArrayList();
}
