package com.xxfc.platform.vehicle.rest;


import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@Slf4j
public class BaseController<Biz extends BaseBiz> extends CommonBaseController {
    
    @Autowired
    protected Biz baseBiz;

    @Autowired
    protected UserAuthConfig userAuthConfig;

    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    UserFeign userFeign;


  public String getUserName()throws Exception{ return  userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getUniqueName(); }

    public Biz getBaseBiz() {
        return baseBiz;
    }

    public String getUserId()throws Exception{ return  userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getId(); }


    public List<Integer> getCompanyIds(){
        Integer currentUserIdInt = getCurrentUserIdInt();
        if (currentUserIdInt != null && currentUserIdInt > 0 ){
            ObjectRestResponse<UserDTO> restResponse = userFeign.userinfoByAppUserIdV2(currentUserIdInt);
            if (restResponse.getData() != null){
                UserDTO userDTO =restResponse.getData();
                if (userDTO != null){
                    return  userDTO.getCompanyIds();
                }
            }
        }
        return  null;
    }

}
