package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleExtensionBiz;
import com.xxfc.platform.vehicle.pojo.vo.VehicleExtensionVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/vehicleEextension")
@Api(tags = {"商家入驻"})
public class AppVehicleExtensionController extends BaseController<VehicleExtensionBiz> {





    @GetMapping("tree")
    @ApiModelProperty("商品详情")
    public  ObjectRestResponse info(@RequestParam(value = "vehicleId",defaultValue = "")String  vehicleId,@RequestParam(value = "extensionList",defaultValue = "")String  extensionList) {
        List<VehicleExtensionVO> list=null;
        if (StringUtils.isNotBlank(vehicleId)){
            list=baseBiz.getTree(vehicleId);
        }else if (StringUtils.isNotBlank(extensionList)){
            list=baseBiz.getTreeByApply(Arrays.asList(extensionList.split(",")).parallelStream().map(s -> Integer.valueOf(s)).collect(Collectors.toList()));
        }
        return  ObjectRestResponse.succ(list);
    }















}
