package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleApplyBiz;
import com.xxfc.platform.vehicle.biz.VehicleBiz;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.pojo.dto.VehicleFindDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/vehicle")
@Api(tags = {"商家入驻"})
public class AppVehicleController extends BaseController<VehicleBiz> {





    @GetMapping("selectList")
    @ApiModelProperty("商品列表")
    public  ObjectRestResponse selectList(VehicleFindDTO vehicleFindDTO) {
        if (vehicleFindDTO.getBranchId() == null || vehicleFindDTO.getBranchId() == 0){
            List<Integer> companyIds = getCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                vehicleFindDTO.setBranchId(companyIds.get(0));
            }
        }
        return  baseBiz.selectList(vehicleFindDTO);
    }


    @PostMapping("updVehicle")
    @ApiModelProperty("更新商品信息")
    public  ObjectRestResponse updVehicle(@RequestBody Vehicle vehicle) {
        baseBiz.updateSelectiveById(vehicle);
        return ObjectRestResponse.succ();
    }


    @GetMapping("info")
    @ApiModelProperty("商品详情")
    public  ObjectRestResponse info(VehicleFindDTO vehicleFindDTO) {
        return  ObjectRestResponse.succ(baseBiz.info(vehicleFindDTO));
    }

    @GetMapping("detail/{id}")
    @ApiModelProperty("商品详情")
    public  ObjectRestResponse detail(@PathVariable("id") String id ) {
        return  ObjectRestResponse.succ(baseBiz.selectById(id));
    }















}
